/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.javaToMetaRefs.widgetName.reference;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import java.util.Optional;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.javaToMetaRefs.widgetName.reference.JavaWidgetNameReferenceContributor;
import org.jetbrains.annotations.NotNull;

public final class JavaWidgetNameReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaWidgetNameReferenceInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLiteralExpression(element);
                if (!JavaWidgetNameReferenceContributor.Holder.JAVA_WIDGET_NAME_REF_PATTERN.accepts((Object)element)) {
                    return;
                }
                String originalText = element.getText();
                String value = originalText.replace("\"", "");
                Project project = element.getProject();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return;
                }
                Optional link = (Optional)JWidget.getLinkAndAutocompletionByWidgetName(value, project, module).getFirst();
                if (link.isEmpty()) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, new TextRange(1, value.length() + 1), "Incorrect value. Use autocomplete to provide correct one", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new QuickFixUtils.ClearJavaPsiLiteralValueAndCallAutocompletionFix("Select value with autocompletion", (PsiElement)element)}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/cxbox/intellij/community/javaToMetaRefs/widgetName/reference/JavaWidgetNameReferenceInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/cxbox/intellij/community/javaToMetaRefs/widgetName/reference/JavaWidgetNameReferenceInspection", "buildVisitor"));
    }
}

