/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.generator;

import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.cxbox.intellij.community.common.util.DataResponseDTOUtil;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;
import org.cxbox.intellij.community.common.util.FieldWithAnnotation;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.common.util.StringUtilsKt;
import org.cxbox.intellij.community.common.util.VersionAwareServiceUtils;
import org.cxbox.intellij.community.wigdet.fields.field.generator.AbstractVersionAwareWidgetNewFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.PlatformDisplayName;
import org.cxbox.intellij.community.wigdet.fields.field.generator.TemplatesKt;
import org.jetbrains.annotations.NotNull;

@PlatformDisplayName(name="generate using LOV (e.g. available values will be stored in DICTIONARY_ITEM db table)")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J@\u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/cxbox/intellij/community/wigdet/fields/field/generator/DictionaryLOVFieldGenerator;", "Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator;", "prj", "Lcom/intellij/openapi/project/Project;", "fieldNameLiteral", "Lcom/intellij/json/psi/JsonStringLiteral;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/json/psi/JsonStringLiteral;)V", "fieldTypes", "", "", "prepareFieldCreation", "Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Result;", "prepareDictionary", "pkg", "persistenceVersion", "fieldName", "dtoPsiClass", "Lcom/intellij/psi/PsiClass;", "dtoMetaPsiClzFQN", "entityPsiClass", "cxbox-intellij-plugin"})
public final class DictionaryLOVFieldGenerator
extends AbstractVersionAwareWidgetNewFieldGenerator {
    public DictionaryLOVFieldGenerator(@NotNull Project prj, @NotNull JsonStringLiteral fieldNameLiteral) {
        Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
        Intrinsics.checkNotNullParameter((Object)fieldNameLiteral, (String)"fieldNameLiteral");
        super(prj, fieldNameLiteral);
    }

    @Override
    @NotNull
    public List<String> fieldTypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public AbstractVersionAwareWidgetNewFieldGenerator.Result prepareFieldCreation() {
        return this.prepareDictionary(this.getPrj(), this.getPkg(), this.getPersistenceVersion(), this.getFieldName(), this.getDtoPsiClz(), this.getDtoMetaPsiClzFQN(), this.getEntityPsiClz());
    }

    private final AbstractVersionAwareWidgetNewFieldGenerator.Result prepareDictionary(Project prj, String pkg, String persistenceVersion, String fieldName, PsiClass dtoPsiClass, String dtoMetaPsiClzFQN, PsiClass entityPsiClass) {
        AbstractVersionAwareWidgetNewFieldGenerator.Result result = new AbstractVersionAwareWidgetNewFieldGenerator.Result();
        String enumQN = AbstractVersionAwareWidgetNewFieldGenerator.Companion.createEnum(prj, fieldName, dtoPsiClass, entityPsiClass);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)dtoPsiClass));
        if (module == null) {
            throw new IllegalStateException();
        }
        GlobalSearchScope globalSearchScope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, prj);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleSearchScopeWith\u2026ndChildsAndLibraries(...)");
        GlobalSearchScope scp = globalSearchScope;
        PsiClassType psiClassType = PsiType.getTypeByName((String)"java.lang.String", (Project)prj, (GlobalSearchScope)scp);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getTypeByName(...)");
        PsiClassType dtoFieldType = psiClassType;
        PsiClassType psiClassType2 = PsiType.getTypeByName((String)(pkg + ".api.data.dictionary.LOV"), (Project)prj, (GlobalSearchScope)scp);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"getTypeByName(...)");
        PsiClassType entityFieldType = psiClassType2;
        String projectLevelDictionaryAnnotationQN = "@AdministeredDictionary";
        String iDictionaryTypeQN = enumQN;
        FieldWithAnnotation it = new FieldWithAnnotation();
        boolean bl = false;
        it.setField(TemplatesKt.getBasicDtoField(fieldName, (PsiType)dtoFieldType));
        String dictionaryType = StringUtilsKt.camelToUpperSnakeCase(fieldName);
        it.getAnnotations().add(projectLevelDictionaryAnnotationQN + "(" + iDictionaryTypeQN + ")");
        it.getAnnotations().add("@" + pkg + ".core.util.filter.SearchParameter(name = \"" + fieldName + "\", provider = " + pkg + ".core.util.filter.provider.impl.LovValueProvider.class)");
        result.getDtoFields().add(it);
        it = new FieldWithAnnotation();
        boolean bl2 = false;
        it.setField(TemplatesKt.getDtoMetaModelFieldBasic(dtoPsiClass, pkg, fieldName, dtoFieldType));
        result.getDtoMetaModelFields().add(it);
        it = new FieldWithAnnotation();
        boolean bl3 = false;
        it.setField(TemplatesKt.getBasicEntityField(fieldName, (PsiType)entityFieldType));
        it.getAnnotations().add("@" + persistenceVersion + ".Column");
        result.getEntityFields().add(it);
        result.getRowIndependentMeta().add(arg_0 -> DictionaryLOVFieldGenerator.prepareDictionary$lambda$3(dtoMetaPsiClzFQN, fieldName, arg_0));
        result.getRowIndependentMeta().add(arg_0 -> DictionaryLOVFieldGenerator.prepareDictionary$lambda$4(dtoMetaPsiClzFQN, fieldName, iDictionaryTypeQN, arg_0));
        result.getRowDependentMeta().add(arg_0 -> DictionaryLOVFieldGenerator.prepareDictionary$lambda$5(dtoMetaPsiClzFQN, fieldName, arg_0));
        result.getRowDependentMeta().add(arg_0 -> DictionaryLOVFieldGenerator.prepareDictionary$lambda$6(dtoMetaPsiClzFQN, fieldName, iDictionaryTypeQN, arg_0));
        result.getVersionAwareDoUpdate().add(arg_0 -> DictionaryLOVFieldGenerator.prepareDictionary$lambda$7(dtoMetaPsiClzFQN, fieldName, persistenceVersion, arg_0));
        result.getDtoConstructorMapFormEntity().add(arg_0 -> DictionaryLOVFieldGenerator.prepareDictionary$lambda$8(fieldName, arg_0));
        result.getMapperBuilderPutLines().add(TemplatesKt.getBasicBeanMapperPutLine(dtoMetaPsiClzFQN, fieldName));
        return result;
    }

    private static final String prepareDictionary$lambda$3(String $dtoMetaPsiClzFQN, String $fieldName, FieldMetaBuilderUtil.RowIndependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return TemplatesKt.getRowIndependentBasicEnableFilter($dtoMetaPsiClzFQN, $fieldName, prms);
    }

    private static final String prepareDictionary$lambda$4(String $dtoMetaPsiClzFQN, String $fieldName, String $iDictionaryTypeQN, FieldMetaBuilderUtil.RowIndependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return prms.getFields() + ".setAllFilterValuesByLovType(" + $dtoMetaPsiClzFQN + "." + $fieldName + ", " + $iDictionaryTypeQN + ");";
    }

    private static final String prepareDictionary$lambda$5(String $dtoMetaPsiClzFQN, String $fieldName, FieldMetaBuilderUtil.RowDependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return TemplatesKt.getRowDependentBasicEnabled($dtoMetaPsiClzFQN, $fieldName, prms);
    }

    private static final String prepareDictionary$lambda$6(String $dtoMetaPsiClzFQN, String $fieldName, String $iDictionaryTypeQN, FieldMetaBuilderUtil.RowDependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return prms.getFields() + ".setDictionaryTypeWithAllValues(" + $dtoMetaPsiClzFQN + "." + $fieldName + ", " + $iDictionaryTypeQN + ");";
    }

    private static final String prepareDictionary$lambda$7(String $dtoMetaPsiClzFQN, String $fieldName, String $persistenceVersion, VersionAwareServiceUtils.VersionAwareServiceDoUpdateEntityDto prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return TemplatesKt.basicFieldDoUpdate($dtoMetaPsiClzFQN, $fieldName, prms, $persistenceVersion);
    }

    private static final String prepareDictionary$lambda$8(String $fieldName, DataResponseDTOUtil.DtoConstructorprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return TemplatesKt.getDtoConstructorMapFromEntityBasic($fieldName, prms);
    }
}

