/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.conf;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.conf.JsonTag;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.db.DBService;
import org.cxbox.intellij.community.injection.SimpleLangToMetaFilesValueInjector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLBcUtil {
    public static final String SQL_BC_JSON = ".sqlbc.json";
    public static final JsonTag<JsonStringLiteral> NAME = new JsonTag<JsonStringLiteral>("name", JsonStringLiteral.class, null);
    public static final PsiElementPattern.Capture<JsonValue> SQL_BC_NAME_REF_PATTERN = Common.createPropertyValuePattern(NAME.getName(), ".sqlbc.json");

    @Nullable
    public static PsiNamedElement getSqlBcFileInjectedName(@NotNull Project project, @NotNull Module module, @Nullable JsonValue nameInScreenFile) {
        if (project == null) {
            SQLBcUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(1);
        }
        return SimpleLangToMetaFilesValueInjector.getInjectedName(project, module, nameInScreenFile);
    }

    @NotNull
    public static List<Pair<String, ? extends LookupElement>> getSQLBcAutocompletion(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            SQLBcUtil.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(3);
        }
        List<Pair<String, ? extends LookupElement>> list = SQLBcUtil.getAllSQLBcInjectedNames(project, module).stream().filter(Objects::nonNull).map(e -> Pair.pair((Object)e.getName(), (Object)LookupElementBuilder.create((PsiNamedElement)e).withIcon(AllIcons.Providers.Postgresql).withTypeText("sql rest-endpoint", true))).collect(Collectors.toList());
        if (list == null) {
            SQLBcUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static Optional<PsiNamedElement> getSQLBc(@Nullable String bc, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            SQLBcUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(6);
        }
        if (bc == null) {
            Optional<PsiNamedElement> optional = Optional.empty();
            if (optional == null) {
                SQLBcUtil.$$$reportNull$$$0(7);
            }
            return optional;
        }
        Optional<PsiNamedElement> optional = SQLBcUtil.getAllSQLBcInjectedNames(project, module).stream().filter(bcPsi -> bcPsi != null && bc.equals(bcPsi.getName())).findAny();
        if (optional == null) {
            SQLBcUtil.$$$reportNull$$$0(8);
        }
        return optional;
    }

    public static Collection<VirtualFile> getAllSQLBc(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            SQLBcUtil.$$$reportNull$$$0(9);
        }
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(10);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (Collection)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(SQLBcUtil.getAllSQLBcsNoCache(module), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static Collection<VirtualFile> getAllSQLBcsNoCache(@NotNull Module module) {
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(11);
        }
        Project project = module.getProject();
        GlobalSearchScope scope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        return FilenameIndex.getAllFilesByExt((Project)project, (String)"sqlbc.json", (GlobalSearchScope)scope);
    }

    public static List<PsiNamedElement> getAllSQLBcInjectedNames(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            SQLBcUtil.$$$reportNull$$$0(12);
        }
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(13);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(SQLBcUtil.getAllSQLBcNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    @NotNull
    private static List<PsiNamedElement> getAllSQLBcNoCache(@NotNull Module module) {
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(14);
        }
        Project project = module.getProject();
        List<PsiNamedElement> list = SQLBcUtil.getAllSQLBc(project, module).stream().map(vf -> PsiManager.getInstance((Project)project).findFile(vf)).map(JsonFile.class::cast).map(e -> {
            JsonObject topLevelObject = JsonFacade.getTopLevelObject(e);
            JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAME);
            return SQLBcUtil.getSqlBcFileInjectedName(project, module, (JsonValue)name);
        }).collect(Collectors.toList());
        if (list == null) {
            SQLBcUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> getLinkAndAutocompletionByFieldNameAndBcName(@NotNull String fieldName, @Nullable String bc, @NotNull Project project, @NotNull Module module) {
        if (fieldName == null) {
            SQLBcUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            SQLBcUtil.$$$reportNull$$$0(17);
        }
        if (module == null) {
            SQLBcUtil.$$$reportNull$$$0(18);
        }
        Pair pair = Optional.ofNullable((DBService)project.getService(DBService.class)).map(e -> e.getLinkAndAutocompletionByFieldNameAndBcName(fieldName, bc, project, module)).orElse(Pair.pair(Optional.empty(), List.of()));
        if (pair == null) {
            SQLBcUtil.$$$reportNull$$$0(19);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/conf/SQLBcUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/conf/SQLBcUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSQLBcAutocompletion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSQLBc";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSQLBcNoCache";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByFieldNameAndBcName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSqlBcFileInjectedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSQLBcAutocompletion";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSQLBc";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllSQLBc";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllSQLBcsNoCache";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllSQLBcInjectedNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllSQLBcNoCache";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByFieldNameAndBcName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 15, 19 -> new IllegalStateException(string);
        };
    }
}

