/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.CreClassesFqn;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.PsiCommentUtil;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResponseServiceUtils {
    public static final String VERSION_AWARE_RESPONSE_SERVICE = ".core.crudma.impl.VersionAwareResponseService";
    public static final String ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE = ".core.crudma.impl.AnySourceVersionAwareResponseService";
    public static final ElementPattern<PsiClass> ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE_PATTERN = StandardPatterns.or((ElementPattern[])((ElementPattern[])Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> PsiJavaPatterns.psiClass().inheritorOf(false, prefix + ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE)).toArray(ElementPattern[]::new)));
    public static final ElementPattern<PsiClass> VERSION_AWARE_RESPONSE_SERVICE_PATTERN = StandardPatterns.or((ElementPattern[])((ElementPattern[])Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> PsiJavaPatterns.psiClass().inheritorOf(false, prefix + VERSION_AWARE_RESPONSE_SERVICE)).toArray(ElementPattern[]::new)));

    @NotNull
    public static Optional<PsiClass> getEntityByDto(@Nullable PsiClass dto, @NotNull Module module) {
        List<ResponseServiceData> allResponseServiceData;
        Optional<PsiClass> entityFromService;
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(0);
        }
        if (dto == null || dto.getQualifiedName() == null) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                ResponseServiceUtils.$$$reportNull$$$0(1);
            }
            return optional;
        }
        if (PsiCommentUtil.containCommitWithPrefixes((PsiElement)dto, List.of("@entity:", "//@entity:"))) {
            PsiClass entityClass;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)dto.getProject());
            String comment = PsiCommentUtil.getCommentWithPrefixesAndFullyName((PsiElement)dto, List.of("@entity:", "//@entity:"));
            if (comment != null && (entityClass = javaPsiFacade.findClass(comment, GlobalSearchScope.allScope((Project)dto.getProject()))) != null) {
                Optional<PsiClass> optional = Optional.of(entityClass);
                if (optional == null) {
                    ResponseServiceUtils.$$$reportNull$$$0(2);
                }
                return optional;
            }
        }
        Optional<PsiClass> optional = (entityFromService = (allResponseServiceData = ResponseServiceUtils.getAllResponseServiceData(module.getProject(), module)).stream().filter(e -> e.responseServiceDtoPsiClass.getManager().areElementsEquivalent((PsiElement)e.responseServiceDtoPsiClass, (PsiElement)dto) || e.responseServiceDtoPsiClass.isInheritorDeep(dto, null)).map(ResponseServiceData::responseServiceEntityPsiClass).findFirst()).isEmpty() ? ResponseServiceUtils.getEnittyFromConstructor(dto) : entityFromService;
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(3);
        }
        return optional;
    }

    public static boolean hasVersionAwareResponseServiceConstructorWithoutParam(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(5);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        return Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> prefix + VERSION_AWARE_RESPONSE_SERVICE).map(versionAwareResponseServiceFqn -> javaPsiFacade.findClass(versionAwareResponseServiceFqn, SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project))).filter(Objects::nonNull).map(PsiClass::getConstructors).flatMap(Arrays::stream).filter(Objects::nonNull).anyMatch(constructor -> constructor.getParameters().length == 0);
    }

    @NotNull
    public static List<ResponseServiceData> getAllResponseServiceData(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(6);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(7);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        List list = (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(ResponseServiceUtils.getAllResponseServiceDataNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<ResponseServiceData> getAllResponseServiceDataNoCache(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(9);
        }
        ArrayList<PsiClass> all = new ArrayList<PsiClass>();
        all.addAll(ResponseServiceUtils.getAllAnySourceResponseServiceImplementationsNoCache(module));
        all.addAll(ResponseServiceUtils.getAllResponseServiceImplementationsNoCache(module));
        List<ResponseServiceData> list = all.stream().map(e -> ResponseServiceUtils.getResponseServiceData(e, module)).filter(Objects::nonNull).toList();
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public static ResponseServiceData getResponseServiceData(@NotNull PsiClass responseServicePsiClass, @NotNull Module module) {
        PsiClass responseServiceEntityPsiClass;
        if (responseServicePsiClass == null) {
            ResponseServiceUtils.$$$reportNull$$$0(11);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(12);
        }
        if ((responseServiceEntityPsiClass = (PsiClass)ResponseServiceUtils.getResponseServiceEntity(responseServicePsiClass, module.getProject(), module).orElse(null)) == null && (responseServiceEntityPsiClass = (PsiClass)ResponseServiceUtils.getAnySourceResponseServiceEntity(responseServicePsiClass, module.getProject(), module).orElse(null)) == null) {
            return null;
        }
        PsiClass responseServiceDtoPsiClass = ResponseServiceUtils.getResponseServiceDto(responseServicePsiClass, module.getProject(), module).orElse(null);
        if (responseServiceDtoPsiClass == null) {
            return null;
        }
        return new ResponseServiceData(responseServicePsiClass, responseServiceEntityPsiClass, responseServiceEntityPsiClass.getQualifiedName(), responseServiceDtoPsiClass, responseServiceDtoPsiClass.getQualifiedName());
    }

    @NotNull
    private static List<PsiClass> getAllResponseServiceImplementationsNoCache(@NotNull Module module) {
        PsiClass responseServiceInterface;
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(13);
        }
        if ((responseServiceInterface = ResponseServiceUtils.getResponseServiceInterface(module)) == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ResponseServiceUtils.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<PsiClass> list = JavaUtil.getInterfaceImplementaions(responseServiceInterface).stream().filter(PsiClass.class::isInstance).map(PsiClass.class::cast).toList();
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static List<PsiClass> getAllAnySourceResponseServiceImplementationsNoCache(@NotNull Module module) {
        PsiClass responseServiceInterface;
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(16);
        }
        if ((responseServiceInterface = ResponseServiceUtils.getAnySourceResponseServiceInterface(module)) == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ResponseServiceUtils.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<PsiClass> list = JavaUtil.getInterfaceImplementaions(responseServiceInterface).stream().filter(PsiClass.class::isInstance).map(PsiClass.class::cast).toList();
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public static PsiClass getResponseServiceInterface(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(19);
        }
        return Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".core.service.ResponseService", module);
    }

    @Nullable
    public static PsiClass getAnySourceResponseServiceInterface(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(20);
        }
        return Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".core.service.AnySourceResponseService", module);
    }

    @Nullable
    public static PsiMethod getActions(PsiClass psiClass, @NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(21);
        }
        PsiMethod result = null;
        if (psiClass != null) {
            PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
            String methodName = "getActions";
            if (bcEnumServiceImplClass != null) {
                result = JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
            }
        }
        return result;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceMetaBuilder(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(22);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(23);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.service.rowmeta.FieldMetaBuilder";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getMeta");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(24);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getAnySourceResponseServiceMetaBuilder(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(25);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(26);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.service.rowmeta.FieldMetaBuilder";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getMeta");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(27);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(28);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(29);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getTypeOfDTO");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(30);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceEntity(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(31);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(32);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.BASE_ENTITY_FQN_WITHOUT_PLATFORM.getValue();
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getTypeOfEntity");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(33);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getAnySourceResponseServiceEntity(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(34);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(35);
        }
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, "java.io.Serializable", "getTypeOfEntity");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(36);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getEnittyFromConstructor(@Nullable PsiClass dto) {
        PsiMethod[] constructors = dto.getConstructors();
        List<PsiMethod> constrictorsWithOneParameter = Arrays.stream(constructors).filter(constructor -> constructor.getParameters().length == 1).toList();
        if (constrictorsWithOneParameter.isEmpty()) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                ResponseServiceUtils.$$$reportNull$$$0(37);
            }
            return optional;
        }
        Optional<PsiClass> optional = constrictorsWithOneParameter.stream().map(constructor -> {
            PsiClassType psiClassType;
            PsiClass entity;
            JvmType type = constructors[0].getParameters()[0].getType();
            if (type instanceof PsiClassType && (entity = (psiClassType = (PsiClassType)type).resolve()) != null) {
                return entity;
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(38);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceSuggestionField(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(39);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(40);
        }
        String returnGenericBaseClassFQN = "java.io.Serializable";
        String methodName = "getTypeOfEntity";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(41);
        }
        return optional;
    }

    public static boolean isVersionAwareResponseService(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(42);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(43);
        }
        return bcEnumServiceClass != null && ResponseServiceUtils.hasSuperClass(bcEnumServiceClass, Cache.getPlatformRootPackageWithoutDot(project, module) + VERSION_AWARE_RESPONSE_SERVICE);
    }

    public static boolean isAnySourceVersionAwareResponseService(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(44);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(45);
        }
        return bcEnumServiceClass != null && ResponseServiceUtils.hasSuperClass(bcEnumServiceClass, Cache.getPlatformRootPackageWithoutDot(project, module) + ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE);
    }

    private static boolean hasSuperClass(PsiClass bcEnumServiceClass, String superClassFQN) {
        return Arrays.stream(bcEnumServiceClass.getSupers()).map(PsiClass::getQualifiedName).anyMatch(superClassFQN::equals);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 10, 14, 15, 17, 18, 24, 27, 30, 33, 36, 37, 38, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils";
                break;
            }
            case 4: 
            case 6: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseServicePsiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityByDto";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResponseServiceData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResponseServiceDataNoCache";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResponseServiceImplementationsNoCache";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnySourceResponseServiceImplementationsNoCache";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceMetaBuilder";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnySourceResponseServiceMetaBuilder";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceDto";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceEntity";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnySourceResponseServiceEntity";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnittyFromConstructor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceSuggestionField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEntityByDto";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasVersionAwareResponseServiceConstructorWithoutParam";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllResponseServiceData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllResponseServiceDataNoCache";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllResponseServiceImplementationsNoCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnySourceResponseServiceImplementationsNoCache";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceInterface";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceInterface";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceMetaBuilder";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceMetaBuilder";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceDto";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceEntity";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceEntity";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceSuggestionField";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isVersionAwareResponseService";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isAnySourceVersionAwareResponseService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 10, 14, 15, 17, 18, 24, 27, 30, 33, 36, 37, 38, 41 -> new IllegalStateException(string);
        };
    }

    public record ResponseServiceData(@NotNull PsiClass responseServicePsiClass, PsiClass responseServiceEntityPsiClass, String responseServiceEntityFQN, PsiClass responseServiceDtoPsiClass, String responseServiceDtoFQN) {
        @NotNull
        private final PsiClass responseServicePsiClass;

        public ResponseServiceData {
            if (responseServicePsiClass == null) {
                ResponseServiceData.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public PsiClass responseServicePsiClass() {
            PsiClass psiClass = this.responseServicePsiClass;
            if (psiClass == null) {
                ResponseServiceData.$$$reportNull$$$0(1);
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "responseServicePsiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils$ResponseServiceData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils$ResponseServiceData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "responseServicePsiClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

