/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.inline;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.screen.view.ViewNameReferenceContributor;
import org.cxbox.intellij.community.view.widgets.widgetname.ViewWidgetNameReferenceContributor;
import org.cxbox.intellij.community.wigdet.fields.field.commonProps.key.FieldKeyReferenceContributor;
import org.cxbox.intellij.community.wigdet.fields.field.commonProps.key.FieldKeyReferenceProvider;
import org.cxbox.intellij.community.wigdet.fields.field.type.time.TimeFormatContributor;
import org.cxbox.intellij.community.wigdet.fields.field.type.time.TimeFormatVariant;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.ActionKeyReferenceContributor;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.ActionKeyReferenceProvider;
import org.cxbox.intellij.community.wigdet.options.actionGroups.actionGroup.ActionGroupKeyReferenceContributor;
import org.cxbox.intellij.community.wigdet.options.actionGroups.actionGroup.ActionGroupKeyReferenceProvider;
import org.cxbox.intellij.community.wigdet.options.layout.LayoutFieldKeyReferenceContributor;
import org.cxbox.intellij.community.wigdet.options.layout.LayoutFieldKeyReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    public boolean canShowHintsWhenDisabled() {
        return true;
    }

    public List<InlayInfo> getParameterHints(@NotNull PsiElement elementRaw) {
        PsiElement psiElement;
        if (elementRaw == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if (!(elementRaw instanceof LeafPsiElement) || !((psiElement = elementRaw.getParent()) instanceof JsonStringLiteral)) {
            return new ArrayList<InlayInfo>();
        }
        JsonStringLiteral element = (JsonStringLiteral)psiElement;
        if (LayoutFieldKeyReferenceContributor.Holder.LAYOUT_FIELD_REF_PATTERN.accepts((Object)element)) {
            return this.layoutFieldInlay(element);
        }
        if (FieldKeyReferenceContributor.Holder.WIDGET_DTO_FIELD_REF_PATTERN.accepts((Object)element)) {
            return this.widgetKeyInlay(element);
        }
        if (ViewWidgetNameReferenceContributor.Holder.VIEW_WIDGET_NAME_REF_PATTERN.accepts((Object)element)) {
            return this.viewWidgetNameInlay(element);
        }
        if (ViewNameReferenceContributor.Holder.SCREEN_VIEW_NAME_PATTERN.accepts((Object)element)) {
            return this.screenViewNameInlay(element);
        }
        if (ActionKeyReferenceContributor.Holder.ACTION_FIELD_REF_PATTERN.accepts((Object)element)) {
            List<InlayInfo> inlayInfos = this.widgetAction(element);
            if (inlayInfos.isEmpty() && ActionGroupKeyReferenceContributor.Holder.ACTION_GROUP_REF_PATTERN.accepts((Object)element)) {
                inlayInfos = this.widgetActionGroup(element);
            }
            return inlayInfos;
        }
        if (TimeFormatContributor.Holder.TIME_FIELD_PATTERN.accepts((Object)element)) {
            return this.timeFormatInlay(element);
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<InlayInfo> screenViewNameInlay(@NotNull JsonStringLiteral element) {
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(1);
        }
        JsonFile containingFile = (JsonFile)element.getContainingFile();
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return new ArrayList<InlayInfo>();
        }
        String currentViewName = element.getValue();
        Optional first = (Optional)JView.getLinkAndAutocompletionByViewName(currentViewName, project, module).getFirst();
        if (first.isPresent()) {
            PsiNamedElement psiElement = (PsiNamedElement)first.get();
            PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiElement);
            if (injectionHost != null) {
                int offset;
                PsiFile file = injectionHost.getContainingFile();
                JsonFile viewFile = (JsonFile)file;
                JsonObject viewFileTopLevelObject = JsonFacade.getTopLevelObject(viewFile);
                JsonStringLiteral title = JsonFacade.safeGetPropertyValueOfType(viewFileTopLevelObject, JView.TITLE);
                Map<String, Map<Integer, JsonObject>> viewsAndLevels = JScreen.getScreenViews(containingFile);
                Optional<Object> viewLevel = Optional.empty();
                Map<Integer, JsonObject> integerJsonObjectMap = viewsAndLevels.get(currentViewName);
                if (integerJsonObjectMap == null) {
                    return new ArrayList<InlayInfo>();
                }
                String viewLevelsCommaSeparated = integerJsonObjectMap.keySet().stream().map(String::valueOf).collect(Collectors.joining(","));
                if (viewsAndLevels.get(currentViewName).keySet().size() == 1) {
                    viewLevel = viewsAndLevels.get(currentViewName).keySet().stream().findFirst();
                }
                if ((offset = element.getTextRange().getEndOffset()) > 0) {
                    List<InlayInfo> list = List.of(new InlayInfo(" title : \"" + JsonFacade.safeGetValueAsString((PsiElement)title) + "\", level : \"" + viewLevelsCommaSeparated + "\"" + viewLevel.map(lvl -> JScreen.getTabsWidgetNameByLevel(lvl, project, module).map(widget -> " -> tabs widget: \"" + widget.replace(".widget.json", "") + "\"").orElse("")).orElse(""), element.getTextRange().getEndOffset(), false, true, true, null));
                    if (list == null) {
                        JsonInlayParameterHintsProvider.$$$reportNull$$$0(2);
                    }
                    return list;
                }
            }
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private List<InlayInfo> widgetActionGroup(@NotNull JsonStringLiteral element) {
        Optional<Pair> linkInfo;
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return new ArrayList<InlayInfo>();
        }
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> linkAndAutocompletionByActionGroupName = ActionGroupKeyReferenceProvider.getLinkAndAutocompletionByActionGroupName(element, project, module);
        Optional link = (Optional)linkAndAutocompletionByActionGroupName.getFirst();
        List autoCompletion = (List)linkAndAutocompletionByActionGroupName.getSecond();
        if (link.isPresent() && !autoCompletion.isEmpty() && (linkInfo = autoCompletion.stream().filter(e -> JsonFacade.getValue(element).equals(e.getFirst())).findFirst()).isPresent()) {
            LookupElement second = (LookupElement)linkInfo.get().getSecond();
            LookupElementPresentation presentation = new LookupElementPresentation();
            second.renderElement(presentation);
            int offset = element.getTextRange().getEndOffset();
            if (offset > 0) {
                List<InlayInfo> list = List.of(new InlayInfo((presentation.getTypeText() + Optional.ofNullable(presentation.getTailText()).map(e -> " " + e).orElse("")).replace("null:", ""), element.getTextRange().getEndOffset(), false, false, true, null));
                if (list == null) {
                    JsonInlayParameterHintsProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<InlayInfo> widgetAction(@NotNull JsonStringLiteral element) {
        Optional<Pair> linkInfo;
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(7);
        }
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return new ArrayList<InlayInfo>();
        }
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> linkAndAutocompletionByActionName = ActionKeyReferenceProvider.getLinkAndAutocompletionByActionName(element, project, module);
        Optional link = (Optional)linkAndAutocompletionByActionName.getFirst();
        List autoCompletion = (List)linkAndAutocompletionByActionName.getSecond();
        if (link.isPresent() && !autoCompletion.isEmpty() && (linkInfo = autoCompletion.stream().filter(e -> JsonFacade.getValue(element).equals(e.getFirst())).findFirst()).isPresent()) {
            LookupElement second = (LookupElement)linkInfo.get().getSecond();
            LookupElementPresentation presentation = new LookupElementPresentation();
            second.renderElement(presentation);
            int offset = element.getTextRange().getEndOffset();
            if (offset > 0) {
                List<InlayInfo> list = List.of(new InlayInfo((presentation.getTypeText() + Optional.ofNullable(presentation.getTailText()).map(e -> " " + e).orElse("")).replace("null:", ""), element.getTextRange().getEndOffset(), false, false, true, null));
                if (list == null) {
                    JsonInlayParameterHintsProvider.$$$reportNull$$$0(8);
                }
                return list;
            }
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<InlayInfo> layoutFieldInlay(@NotNull JsonStringLiteral element) {
        Optional<Pair> linkInfo;
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(10);
        }
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return new ArrayList<InlayInfo>();
        }
        Pair<Optional<? extends PsiElement>, List<Pair<String, ? extends LookupElement>>> linkAndAutocompletion = LayoutFieldKeyReferenceProvider.getLinkAndAutocompletionByWidgetFieldName(element, project, module);
        Optional link = (Optional)linkAndAutocompletion.getFirst();
        List autoCompletion = (List)linkAndAutocompletion.getSecond();
        if (link.isPresent() && !autoCompletion.isEmpty() && (linkInfo = autoCompletion.stream().filter(e -> JsonFacade.getValue(element).equals(e.getFirst())).findFirst()).isPresent()) {
            LookupElement second = (LookupElement)linkInfo.get().getSecond();
            LookupElementPresentation presentation = new LookupElementPresentation();
            second.renderElement(presentation);
            int offset = element.getTextRange().getEndOffset();
            if (offset > 0) {
                List<InlayInfo> list = List.of(new InlayInfo((presentation.getTypeText() + Optional.ofNullable(presentation.getTailText()).map(e -> " " + e).orElse("")).replace("null:", ""), offset, false, false, true, null));
                if (list == null) {
                    JsonInlayParameterHintsProvider.$$$reportNull$$$0(11);
                }
                return list;
            }
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private List<InlayInfo> widgetKeyInlay(@NotNull JsonStringLiteral element) {
        Optional<Pair> linkInfo;
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(13);
        }
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return new ArrayList<InlayInfo>();
        }
        Pair<Optional<? extends PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> linkAndAutocompletion = FieldKeyReferenceProvider.getLinkAndAutocompletionByRestResourceName(element, project, module);
        Optional link = (Optional)linkAndAutocompletion.getFirst();
        List autoCompletion = (List)linkAndAutocompletion.getSecond();
        if (link.isPresent() && !autoCompletion.isEmpty() && (linkInfo = autoCompletion.stream().filter(e -> JsonFacade.getValue(element).equals(e.getFirst())).findFirst()).isPresent()) {
            LookupElement second = (LookupElement)linkInfo.get().getSecond();
            LookupElementPresentation presentation = new LookupElementPresentation();
            second.renderElement(presentation);
            List<InlayInfo> list = List.of(new InlayInfo((presentation.getTypeText() + Optional.ofNullable(presentation.getTailText()).map(e -> " " + e).orElse("")).replace("null:", ""), element.getTextRange().getEndOffset(), false, false, true, null));
            if (list == null) {
                JsonInlayParameterHintsProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private List<InlayInfo> viewWidgetNameInlay(@NotNull JsonStringLiteral element) {
        Optional<JWidget.WidgetLookupItem> ref;
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(16);
        }
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return new ArrayList<InlayInfo>();
        }
        Pair<Optional<? extends PsiNamedElement>, List<JWidget.WidgetLookupItem>> linkAndAutocompletionByWidgetName = JWidget.getLinkAndAutocompletionByWidgetName(element.getValue(), project, module);
        Optional first = (Optional)linkAndAutocompletionByWidgetName.getFirst();
        if (first.isPresent() && (ref = ((List)linkAndAutocompletionByWidgetName.getSecond()).stream().filter(e -> e.injectedNamedElement.getElement() != null && Objects.equals(((PsiNamedElement)e.injectedNamedElement.getElement()).getName(), ((PsiNamedElement)first.get()).getName())).findFirst()).isPresent()) {
            List<InlayInfo> list = List.of(new InlayInfo(ref.get().getInlayString(), element.getTextRange().getEndOffset(), false, false, true, null));
            if (list == null) {
                JsonInlayParameterHintsProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private List<InlayInfo> timeFormatInlay(@NotNull JsonStringLiteral element) {
        String example;
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(19);
        }
        if ((example = this.getExampleByFormat(JsonFacade.getValue(element))) != null) {
            List<InlayInfo> list = List.of(new InlayInfo(example, element.getTextRange().getEndOffset(), false, false, true, null));
            if (list == null) {
                JsonInlayParameterHintsProvider.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    private String getExampleByFormat(@NotNull String element) {
        if (element == null) {
            JsonInlayParameterHintsProvider.$$$reportNull$$$0(22);
        }
        return Arrays.stream(TimeFormatVariant.values()).filter(variant -> variant.getFormat().equals(element)).map(TimeFormatVariant::getExample).findFirst().orElse(null);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        return new HashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 17, 18, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRaw";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/inline/JsonInlayParameterHintsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/inline/JsonInlayParameterHintsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "screenViewNameInlay";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "widgetActionGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "widgetAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutFieldInlay";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "widgetKeyInlay";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "viewWidgetNameInlay";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "timeFormatInlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "screenViewNameInlay";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "widgetActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "widgetAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "layoutFieldInlay";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "widgetKeyInlay";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "viewWidgetNameInlay";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "timeFormatInlay";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExampleByFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 17, 18, 20, 21 -> new IllegalStateException(string);
        };
    }
}

