/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.file;

import com.intellij.json.psi.JsonFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetUpdateAddedFileProcessor
extends UpdateAddedFileProcessor {
    public boolean canProcessElement(@NotNull PsiFile file) {
        if (file == null) {
            WidgetUpdateAddedFileProcessor.$$$reportNull$$$0(0);
        }
        if (file instanceof JsonFile) {
            JsonFile jsonFile = (JsonFile)file;
            return jsonFile.getName().endsWith(".widget.json");
        }
        return false;
    }

    public void update(PsiFile file, @Nullable PsiFile originalElement) throws IncorrectOperationException {
        if (file != null && !(file.getViewProvider() instanceof TemplateLanguageFileViewProvider) && file instanceof JsonFile) {
            JsonFile jsonFile = (JsonFile)file;
            String newName = file.getName().replace(".widget.json", "");
            JWidget.setNameTagIfChanged(jsonFile, newName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/cxbox/intellij/community/file/WidgetUpdateAddedFileProcessor", "canProcessElement"));
    }
}

