/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.conf;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JsonTag;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.injection.SimpleLangToMetaFilesValueInjector;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JWidget {
    public static final String NO_LEADING_DOT_WIDGET_JSON = "widget.json";
    public static final String POSTFIX_FIELD_KEY = "FieldKey";
    public static final String WIDGET_JSON = ".widget.json";
    public static final JsonTag<JsonStringLiteral> NAME = new JsonTag<JsonStringLiteral>("name", JsonStringLiteral.class, null);
    public static final PsiElementPattern.Capture<JsonValue> WIDGET_NAME_REF_PATTERN = Common.createPropertyValuePattern(NAME.getName(), ".widget.json");
    public static final JsonTag<JsonStringLiteral> TITLE = new JsonTag<JsonStringLiteral>("title", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> HIDDEN = new JsonTag<JsonStringLiteral>("hidden", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> LABEL = new JsonTag<JsonStringLiteral>("label", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> TYPE = new JsonTag<JsonStringLiteral>("type", JsonStringLiteral.class, null);
    public static final JsonTagValue TYPE_VALUE_FORM = new JsonTagValue("type", "Form");
    public static final JsonTagValue TYPE_VALUE_LIST = new JsonTagValue("type", "List");
    public static final JsonTagValue TYPE_VALUE_PICK_LIST_POPUP = new JsonTagValue("type", "PickListPopup");
    public static final JsonTagValue TYPE_VALUE_ASSOC_LIST_POPUP = new JsonTagValue("type", "AssocListPopup");
    public static final JsonTagValue TYPE_VALUE_GROUPING_HIERARCHY = new JsonTagValue("type", "GroupingHierarchy");
    public static final JsonTagValue TYPE_VALUE_INFO = new JsonTagValue("type", "Info");
    public static final JsonTagValue TYPE_VALUE_ADDITIONAL_INFO = new JsonTagValue("type", "AdditionalInfo");
    public static final JsonTagValue TYPE_VALUE_FORM_POPUP = new JsonTagValue("type", "FormPopup");
    public static final JsonTag<JsonStringLiteral> BC = new JsonTag<JsonStringLiteral>("bc", JsonStringLiteral.class, null);
    public static final JsonTag<JsonObject> SHOW_CONDITION = new JsonTag<JsonObject>("showCondition", JsonObject.class, null);
    public static final JsonTag<JsonStringLiteral> SHOW_CONDITION_BC_NAME = new JsonTag<JsonStringLiteral>("showCondition.bcName", JsonStringLiteral.class, null);
    public static final JsonTag<JsonArray> FIELDS = new JsonTag<JsonArray>("fields", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonArray> FIELDS_FIELDS = new JsonTag<JsonArray>("fields.fields", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonStringLiteral> CUSTOM_FIELDS_KEY = new JsonTag<JsonStringLiteral>("*.fieldKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_KEY = new JsonTag<JsonStringLiteral>("fields.key", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_POPUP_BC_NAME = new JsonTag<JsonStringLiteral>("fields.popupBcName", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> POPUP_BC_NAME = new JsonTag<JsonStringLiteral>("popupBcName", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_FIELD_TYPE = new JsonTag<JsonStringLiteral>("fields.field.type", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_FIELD_FILE_ID_KEY = new JsonTag<JsonStringLiteral>("fields.field.fileIdKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_TYPE = new JsonTag<JsonStringLiteral>("fields.type", JsonStringLiteral.class, null);
    public static final JsonTag<JsonBooleanLiteral> FIELDS_HIDDEN = new JsonTag<JsonBooleanLiteral>("fields.hidden", JsonBooleanLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_FORMAT = new JsonTag<JsonStringLiteral>("fields.format", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_HIDDEN_STRING = new JsonTag<JsonStringLiteral>("fields.hidden", JsonStringLiteral.class, null);
    public static final JsonTag<JsonObject> FIELDS_PICK_MAP = new JsonTag<JsonObject>("fields.pickMap", JsonObject.class, null);
    public static final JsonTag<JsonObject> PICK_MAP = new JsonTag<JsonObject>("pickMap", JsonObject.class, null);
    public static final JsonTagValue FIELDS_TYPE_VALUE_HIDDEN = new JsonTagValue("fields.type", "hidden");
    public static final JsonTagValue FIELDS_TYPE_VALUE_MULTIFIELD = new JsonTagValue("fields.type", "multifield");
    public static final JsonTagValue FIELDS_TYPE_VALUE_PICK_LIST = new JsonTagValue("fields.type", "pickList");
    public static final JsonTag<JsonStringLiteral> FIELDS_BG_COLOR_KEY = new JsonTag<JsonStringLiteral>("fields.bgColorKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonNumberLiteral> FIELDS_DIGITS = new JsonTag<JsonNumberLiteral>("fields.digits", JsonNumberLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_DISPLAYED_KEY = new JsonTag<JsonStringLiteral>("fields.displayedKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_ASSOCIATE_FIELD_KEY = new JsonTag<JsonStringLiteral>("fields.associateFieldKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_ASSOC_VALUE_KEY = new JsonTag<JsonStringLiteral>("fields.assocValueKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FIELDS_FILE_ID_KEY = new JsonTag<JsonStringLiteral>("fields.fileIdKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> ACTIONS_KEY = new JsonTag<JsonStringLiteral>("actionKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonArray> OPTIONS_BUTTONS = new JsonTag<JsonArray>("options.buttons", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonObject> OPTIONS = new JsonTag<JsonObject>("options", JsonObject.class, null);
    public static final JsonTag<JsonObject> RING_PROGRESS_OPTIONS = new JsonTag<JsonObject>("ringProgressOptions", JsonObject.class, null);
    public static final JsonTag<JsonObject> FUNNEL_OPTIONS = new JsonTag<JsonObject>("funnelOptions", JsonObject.class, null);
    public static final JsonTag<JsonObject> STEPS_OPTIONS = new JsonTag<JsonObject>("stepsOptions", JsonObject.class, null);
    public static final JsonTag<JsonObject> LAYOUT = new JsonTag<JsonObject>("options.layout", JsonObject.class, null);
    public static final JsonTag<JsonStringLiteral> RING_PROGRESS_OPTIONS_PERCENT_FIELD = new JsonTag<JsonStringLiteral>("percentField", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> RING_PROGRESS_OPTIONS_NUMBER_FIELD = new JsonTag<JsonStringLiteral>("numberField", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> RING_PROGRESS_OPTIONS_DESCRIPTION_FIELD = new JsonTag<JsonStringLiteral>("descriptionField", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> FUNNEL_OPTIONS_DATA_KEY = new JsonTag<JsonStringLiteral>("dataKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> STEPS_OPTIONS_STEPS_DICTIONARY_KEY = new JsonTag<JsonStringLiteral>("stepsDictionaryKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonObject> OPTIONS_CREATE = new JsonTag<JsonObject>("options.create", JsonObject.class, JsonStringLiteral.class);
    public static final JsonTag<JsonObject> OPTIONS_EDIT = new JsonTag<JsonObject>("options.edit", JsonObject.class, JsonStringLiteral.class);
    public static final JsonTag<JsonArray> WIDGET = new JsonTag<JsonArray>("widget", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonObject> OPTIONS_CREATE_WIDGET = new JsonTag<JsonObject>("options.create." + WIDGET.getName(), JsonObject.class, JsonStringLiteral.class);
    public static final JsonTag<JsonObject> OPTIONS_EDIT_WIDGET = new JsonTag<JsonObject>("options.edit." + WIDGET.getName(), JsonObject.class, JsonStringLiteral.class);
    public static final JsonTag<JsonArray> LAYOUT_ROWS = new JsonTag<JsonArray>("options.layout.rows", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonArray> LAYOUT_ROWS_COLS = new JsonTag<JsonArray>("options.layout.rows.cols", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonStringLiteral> LAYOUT_ROWS_COLS_FIELD_KEY = new JsonTag<JsonStringLiteral>("options.layout.rows.cols.fieldKey", JsonStringLiteral.class, null);
    public static final JsonTag<JsonObject> ACTION_GROUP_KEY = new JsonTag<JsonObject>("actionGroups", JsonObject.class, null);
    public static final JsonTag<JsonArray> INCLUDE_ACTION_OR_ACTION_GROUP_KEY = new JsonTag<JsonArray>("options.actionGroups.include", JsonArray.class, JsonStringLiteral.class);
    public static final JsonTag<JsonArray> DEFAULT_ACTION_GROUP_TYPE_KEY = new JsonTag<JsonArray>("options.actionGroups.*.type", JsonArray.class, JsonStringLiteral.class);
    public static final JsonTag<JsonArray> DEFAULT_SAVE_ACTION_FIELD_KEY = new JsonTag<JsonArray>("options.actionGroups.defaultSave", JsonArray.class, JsonStringLiteral.class);
    public static final JsonTag<JsonArray> EXCLUDE_ACTION_OR_ACTION_GROUP_KEY = new JsonTag<JsonArray>("options.actionGroups.exclude", JsonArray.class, JsonStringLiteral.class);
    public static final JsonTag<JsonStringLiteral> LAYOUT_ROWS_COLS_SPAN = new JsonTag<JsonStringLiteral>("options.layout.rows.cols.span", JsonStringLiteral.class, null);
    public static final JsonTag<JsonObject> ACTION_GROUPS = new JsonTag<JsonObject>("options.actionGroups", JsonObject.class, null);
    public static final JsonTag<JsonArray> ACTION_GROUPS_INCLUDE = new JsonTag<JsonArray>("options.actionGroups.include", JsonArray.class, JsonStringLiteral.class);
    private static final Key<CachedValue<SimpleNamedElement>> INJECTED_CONTROLLER = Key.create((String)"platform.widget.name.injected");

    public static List<String> getFormLikeWidgetTypes() {
        return List.of(TYPE_VALUE_FORM.getValue(), TYPE_VALUE_INFO.getValue(), TYPE_VALUE_FORM_POPUP.getValue(), TYPE_VALUE_ADDITIONAL_INFO.getValue());
    }

    public static String getName(@Nullable JsonFile file) {
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, NAME);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    public static JsonStringLiteral getNameLi(@Nullable JsonFile file) {
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        return JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, NAME);
    }

    public static SimpleNamedElement getInjectedNameNoCache(@Nullable JsonFile file) {
        if (file == null) {
            return null;
        }
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, NAME);
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        return JWidget.getWidgetFileInjectedNameNoCache(project, module, name);
    }

    public static void setNameTagIfChanged(@NotNull JsonFile jsonFile, @NotNull String newValue) {
        if (jsonFile == null) {
            JWidget.$$$reportNull$$$0(0);
        }
        if (newValue == null) {
            JWidget.$$$reportNull$$$0(1);
        }
        String propName = NAME.getName();
        if (!JsonStringLiteral.class.isAssignableFrom(NAME.valueType())) {
            return;
        }
        JsonFacade.safeSetTopLevelPropertyIfChanged(jsonFile, propName, newValue);
    }

    public static void visitWidgetLayoutFieldKeys(@Nullable JsonObject topLevelValue, Consumer<JsonStringLiteral> jsonStringLiteralConsumer) {
        JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelValue, OPTIONS);
        JsonObject layout = JsonFacade.safeGetPropertyValueOfType(options, LAYOUT);
        JsonArray rows = JsonFacade.safeGetPropertyValueOfType(layout, LAYOUT_ROWS);
        List<JsonValue> rowsList = JsonFacade.getChildrenOfTypeAsList((PsiElement)rows, LAYOUT_ROWS.arrayItemType());
        rowsList.forEach(row -> {
            JsonArray cols = JsonFacade.safeGetPropertyValueOfType((JsonObject)row, LAYOUT_ROWS_COLS);
            List<JsonValue> colsList = JsonFacade.getChildrenOfTypeAsList((PsiElement)cols, LAYOUT_ROWS_COLS.arrayItemType());
            colsList.forEach(col -> {
                if (col instanceof JsonObject) {
                    JsonObject joCol = (JsonObject)col;
                    JsonStringLiteral fieldKey = JsonFacade.safeGetPropertyValueOfType(joCol, LAYOUT_ROWS_COLS_FIELD_KEY);
                    jsonStringLiteralConsumer.consume((Object)fieldKey);
                }
            });
        });
    }

    public static List<WidgetLookupItem> getAllInjectedWidgetNames(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JWidget.$$$reportNull$$$0(2);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(3);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JWidget.getAllInjectedWidgetNamesNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    @NotNull
    private static List<WidgetLookupItem> getAllInjectedWidgetNamesNoCache(@NotNull Module module) {
        if (module == null) {
            JWidget.$$$reportNull$$$0(4);
        }
        Project project = module.getProject();
        SmartPointerManager instance = SmartPointerManager.getInstance((Project)project);
        List<JsonFile> allWidgetFiles = JWidget.getAllWidgetFiles(project, module);
        List<WidgetLookupItem> list = allWidgetFiles.stream().map(e -> {
            SimpleNamedElement widgetFileInjectedName = JWidget.getWidgetFileInjectedName(e);
            if (widgetFileInjectedName == null) {
                return null;
            }
            WidgetLookupItem widgetLookupItem = new WidgetLookupItem((SmartPsiElementPointer<PsiNamedElement>)instance.createSmartPsiElementPointer((PsiElement)widgetFileInjectedName));
            widgetLookupItem.type = JWidget.getWidgetType(e);
            widgetLookupItem.title = JWidget.getWidgetTitle(e);
            widgetLookupItem.bc = JWidget.getWidgetBC(e);
            return widgetLookupItem;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            JWidget.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<WidgetLookupItem>> getLinkAndAutocompletionByWidgetName(@NotNull String value, @NotNull Project project, @NotNull Module module) {
        if (value == null) {
            JWidget.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JWidget.$$$reportNull$$$0(7);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(8);
        }
        List<WidgetLookupItem> allInjectedWidgetNames = JWidget.getAllInjectedWidgetNames(project, module);
        Optional<PsiNamedElement> link = allInjectedWidgetNames.stream().filter(e -> e.injectedNamedElement.getElement() != null && value.equals(((PsiNamedElement)e.injectedNamedElement.getElement()).getName())).map(e -> (PsiNamedElement)e.injectedNamedElement.getElement()).findFirst();
        Pair pair = Pair.pair(link, allInjectedWidgetNames);
        if (pair == null) {
            JWidget.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    public static Pair<Optional<? extends PsiElement>, List<Pair<String, ? extends LookupElement>>> getLinkAndAutocompletionByWidgetFieldName(JsonFile widgetFile, @NotNull String fieldName, @NotNull Project project, @NotNull Module module) {
        if (fieldName == null) {
            JWidget.$$$reportNull$$$0(10);
        }
        if (project == null) {
            JWidget.$$$reportNull$$$0(11);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(12);
        }
        Optional widgetFieldsFiltered = JWidget.getWidgetFieldsFiltered(widgetFile, e -> Objects.equals(e.getLeft(), fieldName)).stream().findFirst();
        List<JsonProperty> allWidgetFields = JWidget.getWidgetFieldsFiltered(widgetFile, e -> true);
        return new Pair(widgetFieldsFiltered, allWidgetFields.stream().map(e -> {
            String string;
            String label;
            ArrayList<String> lookupStrings = new ArrayList<String>();
            JsonValue value = JsonFacade.getValue(e);
            JsonObject field = JsonFacade.getParentOfType((PsiElement)value, JsonObject.class);
            String title = JsonFacade.safeGetValueAsString((PsiElement)JsonFacade.safeGetPropertyValueOfType(field, TITLE));
            if (title != null) {
                lookupStrings.add(title);
            }
            if ((label = JsonFacade.safeGetValueAsString((PsiElement)JsonFacade.safeGetPropertyValueOfType(field, LABEL))) != null) {
                lookupStrings.add(label);
            }
            String type = JsonFacade.safeGetValueAsString((PsiElement)JsonFacade.safeGetPropertyValueOfType(field, TYPE));
            if (value instanceof JsonStringLiteral) {
                JsonStringLiteral liValue = (JsonStringLiteral)value;
                v0 = JsonFacade.safeGetValueAsString((PsiElement)liValue);
            } else {
                v0 = string = null;
            }
            if (string == null) {
                return null;
            }
            lookupStrings.add(string);
            Optional<Icon> fieldType = Optional.ofNullable(type).flatMap(StandardFieldType::getByFieldType);
            return Pair.pair((Object)string, (Object)LookupElementBuilder.create((String)string).withIcon((Icon)fieldType.map(StandardFieldType::getIcon).orElse(null)).withTypeText(type).withTailText(" " + Optional.ofNullable(title).orElse("") + Optional.ofNullable(label).orElse(""), true).withLookupStrings(lookupStrings));
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @NotNull
    private static List<JsonProperty> getWidgetFieldsFiltered(JsonFile containingFile, Predicate<Triple<String, JsonObject, JsonArray>> triplePredicate) {
        List<Triple<String, JsonObject, JsonArray>> widgetFields = JWidget.getWidgetFields(containingFile);
        List<JsonProperty> list = widgetFields.stream().filter(triplePredicate).map(e -> {
            JsonObject middle = (JsonObject)e.getMiddle();
            JsonStringLiteral fieldNamePsi = JsonFacade.safeGetPropertyValueOfType(middle, FIELDS_KEY);
            return JsonFacade.getParentOfType((PsiElement)fieldNamePsi, JsonProperty.class);
        }).collect(Collectors.toList());
        if (list == null) {
            JWidget.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static boolean isFieldHidden(@Nullable JsonObject fieldObject) {
        JsonStringLiteral fieldType = JsonFacade.safeGetPropertyValueOfType(fieldObject, FIELDS_TYPE);
        JsonBooleanLiteral fieldHiddenAttr = JsonFacade.safeGetPropertyValueOfType(fieldObject, FIELDS_HIDDEN);
        return fieldType != null && FIELDS_TYPE_VALUE_HIDDEN.getValue().equals(fieldType.getValue()) || fieldHiddenAttr != null && fieldHiddenAttr.getValue();
    }

    public static boolean isFieldInsideMultifield(@Nullable JsonObject fieldObject) {
        JsonProperty fieldsProperty = JsonFacade.getParentOfType((PsiElement)fieldObject, JsonProperty.class);
        JsonObject fieldsPropertyParentObject = JsonFacade.getParentOfType((PsiElement)fieldsProperty, JsonObject.class);
        return JWidget.isFieldMultifield(fieldsPropertyParentObject);
    }

    public static boolean isFieldMultifield(@Nullable JsonObject fieldObject) {
        JsonStringLiteral fieldType = JsonFacade.safeGetPropertyValueOfType(fieldObject, FIELDS_TYPE);
        return fieldType != null && FIELDS_TYPE_VALUE_MULTIFIELD.getValue().equals(fieldType.getValue());
    }

    @Nullable
    public static String getWidgetType(@Nullable JsonFile file) {
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, TYPE);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    @Nullable
    public static String getWidgetTitle(@Nullable JsonFile file) {
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, TITLE);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    @Nullable
    public static String getWidgetBC(@Nullable JsonFile file) {
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, BC);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    @NotNull
    public static List<JsonProperty> getOptionsCreateEditWidgetProperties(@NotNull JsonFile widgetFile) {
        if (widgetFile == null) {
            JWidget.$$$reportNull$$$0(14);
        }
        ArrayList<JsonProperty> result = new ArrayList<JsonProperty>();
        JsonObject topLevelObj = JsonFacade.getTopLevelObject(widgetFile);
        JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelObj, OPTIONS);
        result.addAll(JWidget.getWidget(OPTIONS_EDIT, options));
        result.addAll(JWidget.getWidget(OPTIONS_CREATE, options));
        ArrayList<JsonProperty> arrayList = result;
        if (arrayList == null) {
            JWidget.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Optional<JsonArray> getOptionsIncludeActionProperties(@NotNull JsonFile widgetFile) {
        if (widgetFile == null) {
            JWidget.$$$reportNull$$$0(16);
        }
        JsonObject topLevelObj = JsonFacade.getTopLevelObject(widgetFile);
        JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelObj, OPTIONS);
        JsonObject actionGroups = JsonFacade.safeGetPropertyValueOfType(options, ACTION_GROUPS);
        Optional<JsonArray> optional = Optional.ofNullable(JsonFacade.safeGetPropertyValueOfType(actionGroups, INCLUDE_ACTION_OR_ACTION_GROUP_KEY));
        if (optional == null) {
            JWidget.$$$reportNull$$$0(17);
        }
        return optional;
    }

    @NotNull
    private static List<JsonProperty> getWidget(@NotNull JsonTag<JsonObject> type, @Nullable JsonObject jsonObject) {
        if (type == null) {
            JWidget.$$$reportNull$$$0(18);
        }
        ArrayList<JsonProperty> result = new ArrayList<JsonProperty>();
        Optional.ofNullable(JsonFacade.safeGetPropertyValueOfType(jsonObject, type)).stream().map(jObject -> jObject.findProperty(WIDGET.getName())).filter(Objects::nonNull).forEach(result::add);
        ArrayList<JsonProperty> arrayList = result;
        if (arrayList == null) {
            JWidget.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public static List<Triple<String, JsonObject, JsonArray>> getWidgetFields(@Nullable JsonFile file) {
        ArrayList<Triple<String, JsonObject, JsonArray>> result = new ArrayList<Triple<String, JsonObject, JsonArray>>();
        if (file == null) {
            ArrayList<Triple<String, JsonObject, JsonArray>> arrayList = result;
            if (arrayList == null) {
                JWidget.$$$reportNull$$$0(20);
            }
            return arrayList;
        }
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonArray widgetFields = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, FIELDS);
        List<JsonValue> widgetFieldsObjects = JsonFacade.getChildrenOfTypeAsList((PsiElement)widgetFields, FIELDS.arrayItemType());
        widgetFieldsObjects.forEach(fieldObject -> {
            JsonProperty nestedFieldsProperty = fieldObject.findProperty(FIELDS_FIELDS.getName());
            if (nestedFieldsProperty != null) {
                JsonArray nestedFields = JsonFacade.safeGetPropertyValueOfType(fieldObject, FIELDS_FIELDS);
                List<JsonValue> widgetNestedFieldsObjects = JsonFacade.getChildrenOfTypeAsList((PsiElement)nestedFields, FIELDS_FIELDS.arrayItemType());
                widgetNestedFieldsObjects.forEach(nestedFieldObject -> JWidget.addFieldIfFieldKeyExists(result, nestedFieldObject, nestedFields));
            }
            JWidget.addFieldIfFieldKeyExists(result, fieldObject, widgetFields);
        });
        ArrayList<Triple<String, JsonObject, JsonArray>> arrayList = result;
        if (arrayList == null) {
            JWidget.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static void addFieldIfFieldKeyExists(List<Triple<String, JsonObject, JsonArray>> fieldNameToObject, JsonObject fieldObject, JsonArray fieldsTag) {
        JsonProperty fieldKeyProperty = fieldObject.findProperty(FIELDS_KEY.getName());
        if (fieldKeyProperty != null) {
            JsonStringLiteral fieldKeyValue = JsonFacade.safeGetPropertyValueOfType(fieldObject, FIELDS_KEY);
            fieldNameToObject.add((Triple<String, JsonObject, JsonArray>)new ImmutableTriple((Object)JsonFacade.safeGetValueAsString((PsiElement)fieldKeyValue), (Object)fieldObject, (Object)fieldsTag));
        }
    }

    @NotNull
    public static List<JsonFile> getAllWidgetFiles(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JWidget.$$$reportNull$$$0(22);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(23);
        }
        PsiManager instance = PsiManager.getInstance((Project)project);
        List<JsonFile> list = JWidget.getAllWidgets(project, module).stream().map(arg_0 -> ((PsiManager)instance).findFile(arg_0)).filter(Objects::nonNull).map(JsonFile.class::cast).toList();
        if (list == null) {
            JWidget.$$$reportNull$$$0(24);
        }
        return list;
    }

    public static Collection<VirtualFile> getAllWidgets(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JWidget.$$$reportNull$$$0(25);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(26);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (Collection)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JWidget.getAllWidgetsNoCache(module), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static Collection<VirtualFile> getAllWidgetsNoCache(@NotNull Module module) {
        if (module == null) {
            JWidget.$$$reportNull$$$0(27);
        }
        Project project = module.getProject();
        GlobalSearchScope scope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        return FilenameIndex.getAllFilesByExt((Project)project, (String)NO_LEADING_DOT_WIDGET_JSON, (GlobalSearchScope)scope);
    }

    @NotNull
    public static Optional<JsonFile> getWidgetByName(@Nullable String value, @NotNull GlobalSearchScope scp, @NotNull Project project, @NotNull Module module) {
        if (scp == null) {
            JWidget.$$$reportNull$$$0(28);
        }
        if (project == null) {
            JWidget.$$$reportNull$$$0(29);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(30);
        }
        if (value == null) {
            Optional<JsonFile> optional = Optional.empty();
            if (optional == null) {
                JWidget.$$$reportNull$$$0(31);
            }
            return optional;
        }
        Optional<JsonFile> optional = Stream.of(FilenameIndex.getFilesByName((Project)project, (String)(value + WIDGET_JSON), (GlobalSearchScope)scp)).toList().stream().map(JsonFile.class::cast).findFirst();
        if (optional == null) {
            JWidget.$$$reportNull$$$0(32);
        }
        return optional;
    }

    @Nullable
    private static SimpleNamedElement getWidgetFileInjectedNameNoCache(@NotNull Project project, @NotNull Module module, @Nullable JsonStringLiteral nameInWidgetFile) {
        if (project == null) {
            JWidget.$$$reportNull$$$0(33);
        }
        if (module == null) {
            JWidget.$$$reportNull$$$0(34);
        }
        return SimpleLangToMetaFilesValueInjector.getInjectedName(project, module, (JsonValue)nameInWidgetFile);
    }

    @Nullable
    public static SimpleNamedElement getWidgetFileInjectedName(@NotNull JsonFile jsonFile) {
        if (jsonFile == null) {
            JWidget.$$$reportNull$$$0(35);
        }
        return (SimpleNamedElement)CachedValuesManager.getManager((Project)jsonFile.getProject()).getCachedValue((UserDataHolder)jsonFile, INJECTED_CONTROLLER, () -> new CachedValueProvider.Result((Object)JWidget.getWidgetFileInjectedNameNoCache(jsonFile), new Object[]{jsonFile, ProjectRootManager.getInstance((Project)jsonFile.getProject())}), true);
    }

    @Nullable
    public static SimpleNamedElement getWidgetFileInjectedNameNoCache(@Nullable JsonFile jsonFile) {
        if (jsonFile == null) {
            return null;
        }
        Project project = jsonFile.getProject();
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(jsonFile);
        JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAME);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)jsonFile);
        if (module == null) {
            return null;
        }
        return SimpleLangToMetaFilesValueInjector.getInjectedName(project, module, (JsonValue)name);
    }

    @Nullable
    public static String getFieldType(@Nullable JsonProperty fieldObjectProperty) {
        JsonObject fieldObject = JsonFacade.getParentOfType((PsiElement)fieldObjectProperty, JsonObject.class);
        JsonStringLiteral fieldType = JsonFacade.safeGetPropertyValueOfType(fieldObject, FIELDS_TYPE);
        return JsonFacade.safeGetValueAsString((PsiElement)fieldType);
    }

    @Nullable
    public static JsonStringLiteral getFieldTitle(@Nullable JsonObject fieldObject) {
        return JsonFacade.safeGetPropertyValueOfType(fieldObject, TITLE);
    }

    @Nullable
    public static JsonProperty getFieldTitleProperty(@Nullable JsonObject fieldObject) {
        return fieldObject.findProperty(TITLE.getName());
    }

    @Nullable
    public static JsonProperty getFieldHiddenProperty(@Nullable JsonObject fieldObject) {
        return fieldObject.findProperty(HIDDEN.getName());
    }

    @Nullable
    public static JsonProperty getFieldLabelProperty(@Nullable JsonObject fieldObject) {
        return fieldObject.findProperty(LABEL.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 13, 15, 17, 19, 20, 21, 24, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 22: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/conf/JWidget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/conf/JWidget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInjectedWidgetNamesNoCache";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByWidgetName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetFieldsFiltered";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsCreateEditWidgetProperties";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsIncludeActionProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidget";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetFields";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWidgetFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNameTagIfChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllInjectedWidgetNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllInjectedWidgetNamesNoCache";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 31: 
            case 32: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByWidgetName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByWidgetFieldName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsCreateEditWidgetProperties";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsIncludeActionProperties";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWidget";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllWidgetFiles";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAllWidgets";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllWidgetsNoCache";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetByName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetFileInjectedNameNoCache";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetFileInjectedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 13, 15, 17, 19, 20, 21, 24, 31, 32 -> new IllegalStateException(string);
        };
    }

    public static class JsonTagValue {
        private final String path;
        private final String value;

        JsonTagValue(@NotNull String path, @NotNull String value) {
            if (path == null) {
                JsonTagValue.$$$reportNull$$$0(0);
            }
            if (value == null) {
                JsonTagValue.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getPath() {
            return this.path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/common/conf/JWidget$JsonTagValue";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class WidgetLookupItem {
        @NotNull
        public final SmartPsiElementPointer<PsiNamedElement> injectedNamedElement;
        public String title;
        public String type;
        public String bc;

        public WidgetLookupItem(@NotNull SmartPsiElementPointer<PsiNamedElement> injectedNamedElement) {
            if (injectedNamedElement == null) {
                WidgetLookupItem.$$$reportNull$$$0(0);
            }
            this.injectedNamedElement = injectedNamedElement;
        }

        public String getInlayString() {
            return "type:  \"" + this.type + "\", title : \"" + this.title + "\", bc:  \"" + this.bc + "\"";
        }

        public String getLookupText() {
            return this.type + "(title: " + this.title + ", bc: " + this.bc + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedNamedElement", "org/cxbox/intellij/community/common/conf/JWidget$WidgetLookupItem", "<init>"));
        }
    }
}

