/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.Url;
import java.util.List;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProviderKt;

public class WidgetFieldTypeDocumentationProvider
extends AbstractDocumentationProvider {
    private static HtmlChunk createLink(String refText, @Nls String label) {
        HtmlChunk.Element text = HtmlChunk.text((String)label).wrapWith("code");
        String link = "psi_element://" + refText;
        return HtmlChunk.link((String)link, (HtmlChunk)text);
    }

    @Nullable
    public String generateHoverDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            WidgetFieldTypeDocumentationProvider.$$$reportNull$$$0(0);
        }
        return this.generateDoc(element, originalElement);
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof JsonProperty && Holder.FIELDS_FIELD_TYPE_REF_PATTERN.accepts((Object)((JsonProperty)element).getNameElement())) {
            JsonStringLiteral fieldType = (JsonStringLiteral)((JsonProperty)element).getNameElement();
            String file = SymbolPresentationUtil.getFilePathPresentation((PsiFile)element.getContainingFile());
            String docComment = "go field type documentation";
            String builtInServerUrls = BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls((VirtualFile)element.getContainingFile().getVirtualFile(), (Project)element.getProject(), null).stream().map(Url::toExternalForm).findFirst().orElse(null);
            return this.renderFullDoc(JsonFacade.safeGetValueAsString((PsiElement)fieldType), file, "go field type documentation", builtInServerUrls);
        }
        return null;
    }

    private String renderFullDoc(String fieldType, String file, String docComment, @NotNull String url) {
        if (url == null) {
            WidgetFieldTypeDocumentationProvider.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='definition'><pre>");
        sb.append("field type " + fieldType);
        sb.append(" <a href=\"http://localhost:8000/widget/fields/field/input/input/\">Platform doc</a> ");
        sb.append("</pre></div>");
        sb.append("<div class='content'>");
        sb.append(fieldType);
        sb.append("</div>");
        sb.append("<table class='sections'>");
        this.addKeyValueSection("Type:", fieldType, sb);
        this.addKeyValueSection("File:", file, sb);
        this.addKeyValueSection("Comment:", docComment, sb);
        sb.append("</table>");
        return sb.toString();
    }

    private void addKeyValueSection(String key, String value, StringBuilder sb) {
        sb.append("<tr><td valign='top' class='section'><p>");
        sb.append(key);
        sb.append("</td><td valign='top'>");
        sb.append("<p>");
        sb.append(value);
        sb.append("</td>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/WidgetFieldTypeDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHoverDoc";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renderFullDoc";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Holder {
        public static final PsiElementPattern.Capture<JsonStringLiteral> FIELDS_FIELD_TYPE_REF_PATTERN = Common.createPropertyNamePattern(List.of(JWidget.FIELDS_FIELD_TYPE.getName()), ".widget.json");
    }
}

