/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.createOrEdit;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.jetbrains.annotations.NotNull;

public class CreateEditWidgetReferenceHasCorrectTypeInspection
extends LocalInspectionTool {
    private static final String VALID_OPTIONS_CREATE_EDIT_WIDGET_TYPE_FAMILY = "Form";

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        this.check(manager, (List<ProblemDescriptor>)descriptors, (JsonFile)file, module, project);
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void check(@NotNull InspectionManager manager, List<ProblemDescriptor> descriptors, @NotNull JsonFile jsonFile, @NotNull Module module, @NotNull Project project) {
        if (manager == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(2);
        }
        if (jsonFile == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(5);
        }
        List<JsonProperty> jsonProperties = JWidget.getOptionsCreateEditWidgetProperties(jsonFile);
        jsonProperties.stream().filter(property -> !this.isPropertyValueEmpty((JsonProperty)property)).filter(property -> {
            String widgetName = property.getValue().getText().replaceAll("\"", "");
            String type = JWidget.getWidgetType(JWidget.getWidgetByName(widgetName, SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project), project, module).orElse(null));
            return type == null || !type.endsWith(VALID_OPTIONS_CREATE_EDIT_WIDGET_TYPE_FAMILY);
        }).forEach(property -> {
            String widgetNameFromProperty = property.getValue().getText().replaceAll("\"", "");
            descriptors.add(manager.createProblemDescriptor((PsiElement)property.getValue(), new TextRange(1, widgetNameFromProperty.length() + 1), "Invalid widget type. The type is expected to have family (e.g. postfix) \"Form\"", ProblemHighlightType.WARNING, true, new LocalQuickFix[]{new Fix()}));
        });
    }

    private boolean isPropertyValueEmpty(@NotNull JsonProperty property) {
        if (property == null) {
            CreateEditWidgetReferenceHasCorrectTypeInspection.$$$reportNull$$$0(6);
        }
        if (property.getValue() == null || !(property.getValue() instanceof JsonStringLiteral)) {
            return true;
        }
        String value = property.getValue().getText();
        return value.isEmpty() || "\"\"".equals(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/createOrEdit/CreateEditWidgetReferenceHasCorrectTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyValueEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private Fix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Select value with autocompletion";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select value with autocompletion";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/options/createOrEdit/CreateEditWidgetReferenceHasCorrectTypeInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

