/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.java.JavaBundle;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUtil {
    public static <T, A> Collector<T, ?, Map<A, List<T>>> groupingByWithNullKeys(Function<? super T, ? extends A> classifier) {
        return Collectors.toMap(classifier, Collections::singletonList, (oldList, newEl) -> {
            ArrayList newList = new ArrayList(oldList.size() + 1);
            newList.addAll(oldList);
            newList.addAll(newEl);
            return newList;
        });
    }

    @NotNull
    public static Optional<PsiType> getClassGenericByIndexFromAncestor(@NotNull PsiClass psiClass, @NotNull String inheritorsClassFqn, @NotNull Integer index) {
        List<PsiType> generics;
        if (psiClass == null) {
            JavaUtil.$$$reportNull$$$0(0);
        }
        if (inheritorsClassFqn == null) {
            JavaUtil.$$$reportNull$$$0(1);
        }
        if (index == null) {
            JavaUtil.$$$reportNull$$$0(2);
        }
        if (!(generics = Optional.of(psiClass).stream().map(PsiClass::getSuperTypes).flatMap(Arrays::stream).filter(Objects::nonNull).filter(pct -> {
            PsiClass pctCLass = pct.resolve();
            if (pctCLass != null) {
                return inheritorsClassFqn.equals(pctCLass.getQualifiedName());
            }
            return false;
        }).map(PsiClassType::getParameters).flatMap(Arrays::stream).filter(Objects::nonNull).toList()).isEmpty() && generics.size() - 1 >= index) {
            Optional<PsiType> optional = Optional.of(generics.get(index));
            if (optional == null) {
                JavaUtil.$$$reportNull$$$0(3);
            }
            return optional;
        }
        Optional<PsiType> optional = Optional.empty();
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(4);
        }
        return optional;
    }

    @NotNull
    public static List<PsiClass> getAllInheritorClasses(@NotNull Project project, @NotNull Module module, @Nullable PsiClass ancestorClass) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            JavaUtil.$$$reportNull$$$0(6);
        }
        if (ancestorClass == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                JavaUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<PsiClass> list = ClassInheritorsSearch.search((PsiClass)ancestorClass, (SearchScope)SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project), (boolean)true).findAll().stream().toList();
        if (list == null) {
            JavaUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public static PsiClass getPsiClassByFqnPrefixWithoutPlatformRootPackage(@NotNull Project project, @NotNull GlobalSearchScope scp, @NotNull String psiClassFqnPrefixWithoutPlatformRootPackage) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(9);
        }
        if (scp == null) {
            JavaUtil.$$$reportNull$$$0(10);
        }
        if (psiClassFqnPrefixWithoutPlatformRootPackage == null) {
            JavaUtil.$$$reportNull$$$0(11);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        return Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> javaPsiFacade.findClass(prefix + psiClassFqnPrefixWithoutPlatformRootPackage, scp)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public static Optional<PsiClass> getPriClassFromGenericByIndexFromAncestorClassFqnWithoutPackegPrefix(@NotNull PsiClass psiClass, @NotNull String inheritorsClassFqnWithoutPackegPrefix, @NotNull Integer index) {
        if (psiClass == null) {
            JavaUtil.$$$reportNull$$$0(12);
        }
        if (inheritorsClassFqnWithoutPackegPrefix == null) {
            JavaUtil.$$$reportNull$$$0(13);
        }
        if (index == null) {
            JavaUtil.$$$reportNull$$$0(14);
        }
        Optional<PsiClass> optional = Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> JavaUtil.getPsiTypeFromGenericByIndexFromAncestor(psiClass, prefix + inheritorsClassFqnWithoutPackegPrefix, index).orElse(null)).map(type -> {
            PsiClass psiClass;
            if (type instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type;
                psiClass = classType.resolve();
            } else {
                psiClass = null;
            }
            return psiClass;
        }).filter(Objects::nonNull).findFirst();
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(15);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiType> getPsiTypeFromGenericByIndexFromAncestor(@NotNull PsiClass psiClass, @NotNull String inheritorsClassFqn, @NotNull Integer index) {
        if (psiClass == null) {
            JavaUtil.$$$reportNull$$$0(16);
        }
        if (inheritorsClassFqn == null) {
            JavaUtil.$$$reportNull$$$0(17);
        }
        if (index == null) {
            JavaUtil.$$$reportNull$$$0(18);
        }
        return JavaUtil.getClassGenericByIndexFromAncestor(psiClass, inheritorsClassFqn, index);
    }

    @NotNull
    public static Optional<PsiClass> findPsiClass(@NotNull String classFqn, @NotNull Project project) {
        if (classFqn == null) {
            JavaUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(20);
        }
        Optional<PsiClass> optional = Optional.ofNullable(JavaPsiFacade.getInstance((Project)project).findClass(classFqn, GlobalSearchScope.allScope((Project)project)));
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(21);
        }
        return optional;
    }

    @Nullable
    public static Integer getNextNewLineAfterClassName(@NotNull PsiClass psiClass) {
        PsiFile psiFile;
        if (psiClass == null) {
            JavaUtil.$$$reportNull$$$0(22);
        }
        if (psiClass.getName() != null && (psiFile = psiClass.getContainingFile()) instanceof PsiJavaFile) {
            PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
            String classText = psiJavaFile.getText();
            String textFromClassName = classText.substring(classText.indexOf(psiClass.getName()));
            int signatureEnd = textFromClassName.indexOf("{") + classText.indexOf(psiClass.getName());
            return classText.indexOf("\n", signatureEnd) + signatureEnd + 1;
        }
        return null;
    }

    @NotNull
    public static String capitalizeFirstLetter(@NotNull String data) {
        if (data == null) {
            JavaUtil.$$$reportNull$$$0(23);
        }
        String firstLetter = data.substring(0, 1).toUpperCase();
        String restLetters = data.substring(1);
        String string = firstLetter + restLetters;
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String deCapitalizeFirstLetter(@NotNull String data) {
        if (data == null) {
            JavaUtil.$$$reportNull$$$0(25);
        }
        String firstLetter = data.substring(0, 1).toLowerCase();
        String restLetters = data.substring(1);
        String string = firstLetter + restLetters;
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    public static String toUpperSnakeCase(String input) {
        return input.replaceAll("([a-z0-9])([A-Z])", "$1_$2").replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").toUpperCase(Locale.ROOT);
    }

    @NotNull
    public static Collection<PsiReference> findRefs(PsiMethod method, GlobalSearchScope scope, @Nullable StatusBarProgress progress) {
        AtomicReference refs = new AtomicReference(new ArrayList());
        if (method != null) {
            ProgressManager.getInstance().runProcess(() -> refs.set(ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).findAll()), (ProgressIndicator)progress);
        }
        Collection collection = refs.get();
        if (collection == null) {
            JavaUtil.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiReference> findRefs(PsiClass psiClass, GlobalSearchScope scope, @Nullable StatusBarProgress progress) {
        AtomicReference refs = new AtomicReference(new ArrayList());
        if (psiClass != null) {
            ProgressManager.getInstance().runProcess(() -> refs.set(ReferencesSearch.search((PsiElement)psiClass, (SearchScope)scope, (boolean)false).findAll()), (ProgressIndicator)progress);
        }
        Collection collection = refs.get();
        if (collection == null) {
            JavaUtil.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    public static Optional<PsiClass> getMostConcreteInheritorInList(@NotNull List<Optional<PsiClass>> list) {
        if (list == null) {
            JavaUtil.$$$reportNull$$$0(29);
        }
        PsiClass result = null;
        for (Optional<PsiClass> e : list) {
            if (!e.isPresent()) continue;
            if (result == null) {
                result = e.get();
                continue;
            }
            if (!e.get().isInheritorDeep(result, null)) continue;
            result = e.get();
        }
        Optional<Object> optional = Optional.ofNullable(result);
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(30);
        }
        return optional;
    }

    @Nullable
    public static String safeGetEnumFirstStringArgument(@NotNull PsiEnumConstant psiEnumConstant) {
        PsiExpressionList argumentList;
        if (psiEnumConstant == null) {
            JavaUtil.$$$reportNull$$$0(31);
        }
        if ((argumentList = JavaUtil.decompileIfNeeded(psiEnumConstant).getArgumentList()) == null) {
            return null;
        }
        if (argumentList.getExpressions().length < 1) {
            return null;
        }
        PsiExpression firstArgument = argumentList.getExpressions()[0];
        if (firstArgument instanceof PsiLiteralExpression) {
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)firstArgument;
            return PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)psiLiteralExpression);
        }
        return null;
    }

    @NotNull
    public static PsiEnumConstant decompileIfNeeded(@NotNull PsiEnumConstant psiEnumConstant) {
        if (psiEnumConstant == null) {
            JavaUtil.$$$reportNull$$$0(32);
        }
        if (psiEnumConstant instanceof ClsEnumConstantImpl) {
            ClsEnumConstantImpl clsEnumConstant = (ClsEnumConstantImpl)psiEnumConstant;
            PsiEnumConstant psiEnumConstant2 = (PsiEnumConstant)clsEnumConstant.getNavigationElement();
            if (psiEnumConstant2 == null) {
                JavaUtil.$$$reportNull$$$0(33);
            }
            return psiEnumConstant2;
        }
        PsiEnumConstant psiEnumConstant3 = psiEnumConstant;
        if (psiEnumConstant3 == null) {
            JavaUtil.$$$reportNull$$$0(34);
        }
        return psiEnumConstant3;
    }

    @NotNull
    public static Optional<PsiClass> findDeepMethodByNameAndReturnTypeIsDeepInheritorOf(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module, @NotNull String returnGenericBaseClassFQN, @NotNull String methodName) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(35);
        }
        if (module == null) {
            JavaUtil.$$$reportNull$$$0(36);
        }
        if (returnGenericBaseClassFQN == null) {
            JavaUtil.$$$reportNull$$$0(37);
        }
        if (methodName == null) {
            JavaUtil.$$$reportNull$$$0(38);
        }
        PsiClass result = null;
        if (bcEnumServiceClass != null) {
            Collection visibleSignatures = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)bcEnumServiceClass);
            for (HierarchicalMethodSignature methodSignature : visibleSignatures) {
                PsiClass candidate = null;
                if (methodSignature.getName().equals(methodName)) {
                    JavaPsiFacade javaPsiFacade;
                    PsiClass dtoBaseClass;
                    PsiType substitutedReturnType;
                    PsiType[] returnTypes;
                    PsiType returnType;
                    PsiMethod method = methodSignature.getMethod();
                    if (method instanceof ClsMethodImpl) {
                        ClsMethodImpl classMethod = (ClsMethodImpl)method;
                        PsiMethod sourceMirrorMethod = classMethod.getSourceMirrorMethod();
                        PsiMethod psiMethod = method = sourceMirrorMethod != null ? sourceMirrorMethod : method;
                    }
                    if (method == null || (returnType = (returnTypes = JavaUtil.getReturnTypeCandidates(method)) != null && returnTypes.length > 0 ? returnTypes[0] : method.getReturnType()) == null || !((substitutedReturnType = methodSignature.getSubstitutor().substitute(returnType)) instanceof PsiClassType)) continue;
                    PsiClassType psiClassType = (PsiClassType)substitutedReturnType;
                    PsiClassType dto = psiClassType;
                    if (dto instanceof PsiWildcardType) {
                        PsiWildcardType wildcardType = (PsiWildcardType)dto;
                        PsiType bound = wildcardType.getBound();
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)bound);
                    } else {
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)dto);
                    }
                    if (candidate == null || (dtoBaseClass = (javaPsiFacade = JavaPsiFacade.getInstance((Project)project)).findClass(returnGenericBaseClassFQN, candidate.getResolveScope())) == null || !candidate.isInheritorDeep(dtoBaseClass, null)) continue;
                }
                if (candidate == null) continue;
                if (result == null) {
                    result = candidate;
                    continue;
                }
                if (!candidate.isInheritorDeep(result, null)) continue;
                result = candidate;
            }
        }
        Optional<Object> optional = Optional.ofNullable(result);
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(39);
        }
        return optional;
    }

    private static PsiType[] getReturnTypeCandidates(@NotNull PsiMethod method) {
        PsiType[] psiTypeArray;
        if (method == null) {
            JavaUtil.$$$reportNull$$$0(40);
        }
        PsiPrimitiveType lub = null;
        boolean hasVoid = false;
        for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiMethod)method)) {
            PsiType type;
            PsiField valueFieldRef;
            PsiReferenceExpression valueExpr;
            PsiElement psiElement;
            PsiExpression value = statement.getReturnValue();
            if (value == null) {
                hasVoid = true;
                continue;
            }
            PsiType fieldInitializerType = null;
            if (value instanceof PsiReferenceExpression && (psiElement = (valueExpr = (PsiReferenceExpression)value).resolve()) instanceof PsiField && (valueFieldRef = (PsiField)psiElement).getInitializer() != null) {
                fieldInitializerType = valueFieldRef.getInitializer().getType();
            }
            PsiType returnStatementType = value.getType();
            if (fieldInitializerType != null && returnStatementType != null) {
                type = GenericsUtil.getLeastUpperBound((PsiType)returnStatementType, (PsiType)fieldInitializerType, (PsiManager)method.getManager());
            } else {
                PsiType psiType = type = fieldInitializerType != null ? fieldInitializerType : returnStatementType;
            }
            if (lub == null) {
                lub = type;
                continue;
            }
            if (type == null) continue;
            lub = GenericsUtil.getLeastUpperBound((PsiType)lub, (PsiType)type, (PsiManager)method.getManager());
        }
        if (hasVoid && lub == null) {
            lub = new PsiPrimitiveType(JvmPrimitiveTypeKind.VOID, PsiAnnotation.EMPTY_ARRAY);
        }
        if (lub instanceof PsiIntersectionType) {
            PsiIntersectionType a = (PsiIntersectionType)lub;
            return a.getConjuncts();
        }
        if (lub == null) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
        } else {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = lub;
        }
        return psiTypeArray;
    }

    @NotNull
    public static Optional<PsiClass> findDeepMethodByNameAndReturnStatementTypeIsDeepInheritorOf(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module, @NotNull String returnGenericBaseClassFQN, @NotNull String methodName) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(41);
        }
        if (module == null) {
            JavaUtil.$$$reportNull$$$0(42);
        }
        if (returnGenericBaseClassFQN == null) {
            JavaUtil.$$$reportNull$$$0(43);
        }
        if (methodName == null) {
            JavaUtil.$$$reportNull$$$0(44);
        }
        PsiClass result = null;
        if (bcEnumServiceClass != null) {
            Collection visibleSignatures = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)bcEnumServiceClass);
            for (HierarchicalMethodSignature methodSignature : visibleSignatures) {
                PsiClass candidate = null;
                if (methodSignature.getName().equals(methodName)) {
                    JavaPsiFacade javaPsiFacade;
                    PsiClass dtoBaseClass;
                    PsiType[] returnTypes;
                    PsiMethod method = methodSignature.getMethod();
                    if (method instanceof ClsMethodImpl) {
                        ClsMethodImpl classMethod = (ClsMethodImpl)method;
                        PsiMethod sourceMirrorMethod = classMethod.getSourceMirrorMethod();
                        method = sourceMirrorMethod != null ? sourceMirrorMethod : method;
                    }
                    PsiType returnType = (returnTypes = JavaUtil.getReturnTypeCandidates(method)) != null && returnTypes.length > 0 ? returnTypes[0] : method.getReturnType();
                    PsiType substitutedReturnType = methodSignature.getSubstitutor().substitute(returnType);
                    if (!(substitutedReturnType instanceof PsiClassType)) continue;
                    PsiClassType psiClassType = (PsiClassType)substitutedReturnType;
                    PsiClassType dto = psiClassType;
                    if (dto instanceof PsiWildcardType) {
                        PsiWildcardType wildcardType = (PsiWildcardType)dto;
                        PsiType bound = wildcardType.getBound();
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)bound);
                    } else {
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)dto);
                    }
                    if (candidate == null || (dtoBaseClass = (javaPsiFacade = JavaPsiFacade.getInstance((Project)project)).findClass(returnGenericBaseClassFQN, candidate.getResolveScope())) == null || !candidate.isInheritorDeep(dtoBaseClass, null)) continue;
                }
                if (candidate == null) continue;
                if (result == null) {
                    result = candidate;
                    continue;
                }
                if (!candidate.isInheritorDeep(result, null)) continue;
                result = candidate;
            }
        }
        Optional<Object> optional = Optional.ofNullable(result);
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(45);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull String returnGenericBaseClassFQN, @NotNull String methodName) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(46);
        }
        if (returnGenericBaseClassFQN == null) {
            JavaUtil.$$$reportNull$$$0(47);
        }
        if (methodName == null) {
            JavaUtil.$$$reportNull$$$0(48);
        }
        PsiClass result = null;
        if (bcEnumServiceClass != null) {
            Collection visibleSignatures = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)bcEnumServiceClass);
            for (HierarchicalMethodSignature methodSignature : visibleSignatures) {
                PsiClass candidate = null;
                if (methodSignature.getName().equals(methodName)) {
                    JavaPsiFacade javaPsiFacade;
                    PsiClass dtoBaseClass;
                    PsiClassType psiClassType;
                    PsiType[] parameters;
                    PsiMethod method = methodSignature.getMethod();
                    if (method instanceof ClsMethodImpl) {
                        ClsMethodImpl classMethod = (ClsMethodImpl)method;
                        PsiMethod sourceMirrorMethod = classMethod.getSourceMirrorMethod();
                        PsiMethod psiMethod = method = sourceMirrorMethod != null ? sourceMirrorMethod : method;
                    }
                    if (method == null) continue;
                    PsiType[] returnTypes = JavaUtil.getReturnTypeCandidates(method);
                    PsiType returnType = returnTypes != null && returnTypes.length > 0 ? returnTypes[0] : method.getReturnType();
                    PsiType substitutedReturnType = methodSignature.getSubstitutor().substitute(returnType);
                    if (!(substitutedReturnType instanceof PsiClassType) || (parameters = (psiClassType = (PsiClassType)substitutedReturnType).getParameters()).length != 1) continue;
                    PsiType dto = parameters[0];
                    if (dto instanceof PsiWildcardType) {
                        PsiWildcardType wildcardType = (PsiWildcardType)dto;
                        PsiType bound = wildcardType.getBound();
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)bound);
                    } else {
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)dto);
                    }
                    if (candidate == null || (dtoBaseClass = (javaPsiFacade = JavaPsiFacade.getInstance((Project)project)).findClass(returnGenericBaseClassFQN, candidate.getResolveScope())) == null || !candidate.isInheritorDeep(dtoBaseClass, null)) continue;
                }
                if (candidate == null) continue;
                if (result == null) {
                    result = candidate;
                    continue;
                }
                if (!candidate.isInheritorDeep(result, null)) continue;
                result = candidate;
            }
        }
        Optional<Object> optional = Optional.ofNullable(result);
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(49);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull String returnGenericBaseClassFQN, @NotNull String methodName) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(50);
        }
        if (returnGenericBaseClassFQN == null) {
            JavaUtil.$$$reportNull$$$0(51);
        }
        if (methodName == null) {
            JavaUtil.$$$reportNull$$$0(52);
        }
        PsiClass result = null;
        if (bcEnumServiceClass != null) {
            Collection visibleSignatures = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)bcEnumServiceClass);
            for (HierarchicalMethodSignature methodSignature : visibleSignatures) {
                PsiClass candidate = null;
                if (methodSignature.getName().equals(methodName)) {
                    JavaPsiFacade javaPsiFacade;
                    PsiClass dtoBaseClass;
                    PsiClassType psiClassType;
                    PsiType[] parameters;
                    PsiMethod method = methodSignature.getMethod();
                    if (method instanceof ClsMethodImpl) {
                        ClsMethodImpl classMethod = (ClsMethodImpl)method;
                        PsiMethod sourceMirrorMethod = classMethod.getSourceMirrorMethod();
                        PsiMethod psiMethod = method = sourceMirrorMethod != null ? sourceMirrorMethod : method;
                    }
                    if (method == null) continue;
                    PsiType[] returnTypes = JavaUtil.getReturnTypeCandidates(method);
                    PsiType returnType = returnTypes != null && returnTypes.length > 0 ? returnTypes[0] : method.getReturnType();
                    PsiType substitutedReturnType = methodSignature.getSubstitutor().substitute(returnType);
                    if (!(substitutedReturnType instanceof PsiClassType) || (parameters = (psiClassType = (PsiClassType)substitutedReturnType).getParameters()).length != 1) continue;
                    PsiType dto = parameters[0];
                    if (dto instanceof PsiWildcardType) {
                        PsiWildcardType wildcardType = (PsiWildcardType)dto;
                        PsiType bound = wildcardType.getBound();
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)bound);
                    } else {
                        candidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)dto);
                    }
                    if (candidate == null || (dtoBaseClass = (javaPsiFacade = JavaPsiFacade.getInstance((Project)project)).findClass(returnGenericBaseClassFQN, candidate.getResolveScope())) == null || !candidate.isInheritorDeep(dtoBaseClass, null)) continue;
                }
                if (candidate == null) continue;
                if (result == null) {
                    result = candidate;
                    continue;
                }
                if (!candidate.isInheritorDeep(result, null)) continue;
                result = candidate;
            }
        }
        Optional<Object> optional = Optional.ofNullable(result);
        if (optional == null) {
            JavaUtil.$$$reportNull$$$0(53);
        }
        return optional;
    }

    @Nullable
    public static PsiMethod getMethodThatOverridesParentMethod(PsiClass psiClass, String methodName) {
        PsiMethod result = null;
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null) {
            PsiMethod[] superMethods = superClass.findMethodsByName(methodName, true);
            result = Arrays.stream(psiClass.findMethodsByName(methodName, true)).filter(m -> Arrays.stream(superMethods).anyMatch(sm -> PsiSuperMethodUtil.isSuperMethod((PsiMethod)m, (PsiMethod)sm))).findFirst().orElse(null);
        }
        return result;
    }

    public static List<NavigatablePsiElement> getInterfaceImplementaions(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaUtil.$$$reportNull$$$0(54);
        }
        if (DumbService.isDumb((Project)aClass.getProject())) {
            DumbService.getInstance((Project)aClass.getProject()).showDumbModeNotification(JavaBundle.message((String)"notification.navigation.to.overriding.methods", (Object[])new Object[0]));
            return new ArrayList<NavigatablePsiElement>();
        }
        SearchScope scp = aClass.getUseScope();
        ArrayList<NavigatablePsiElement> inheritors = new ArrayList<NavigatablePsiElement>();
        Collection all = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scp, (boolean)true).findAll();
        inheritors.addAll(all);
        if (all.isEmpty()) {
            inheritors.addAll(FunctionalExpressionSearch.search((PsiClass)aClass).findAll());
        }
        return inheritors;
    }

    @Nullable
    public static PsiClass getAnyImplementationIfInterfaceOrElseClass(@Nullable PsiClass bcEnumServiceClass) {
        if (bcEnumServiceClass == null) {
            return null;
        }
        PsiClass bcEnumServiceImplClass = null;
        if (bcEnumServiceClass.isInterface()) {
            List<NavigatablePsiElement> list = JavaUtil.getInterfaceImplementaions(bcEnumServiceClass);
            if (!list.isEmpty()) {
                bcEnumServiceImplClass = (PsiClass)list.get(0);
            }
        } else {
            bcEnumServiceImplClass = bcEnumServiceClass;
        }
        return bcEnumServiceImplClass;
    }

    @Nullable
    public static PsiClass getConstructorSuperCallParamWithTypeInheritedFromClass(PsiMethod constructor, PsiClass psiClass) {
        PsiMethodCallExpression thisOrSuperCallInConstructor;
        if (constructor != null && psiClass != null && (thisOrSuperCallInConstructor = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor)) != null) {
            PsiExpressionList argumentList = thisOrSuperCallInConstructor.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            return JavaUtil.getPsiClassFromExpressionsWithTypeInheritedIfPossibly(expressions, psiClass);
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClassFromConstructorOrFieldOrGetter(PsiClass classToSearchIn, String ancestorFqnPostfixWithPoint, String fieldName) {
        PsiClass fieldMetaBuilderFromConstructor;
        PsiMethod[] constructors = classToSearchIn.getConstructors();
        Project project = classToSearchIn.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)classToSearchIn);
        if (module == null) {
            return null;
        }
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        PsiClass ancestorClass = JavaUtil.getPsiClassByFqnPrefixWithoutPlatformRootPackage(project, scp, ancestorFqnPostfixWithPoint);
        if (ancestorClass == null) {
            return null;
        }
        PsiClass psiClass = fieldMetaBuilderFromConstructor = constructors.length > 0 ? JavaUtil.getConstructorSuperCallParamWithTypeInheritedFromClass(constructors[0], ancestorClass) : null;
        if (fieldMetaBuilderFromConstructor == null) {
            return JavaUtil.getPsiClassFromFieldOrGetter(classToSearchIn, ancestorClass, fieldName);
        }
        return fieldMetaBuilderFromConstructor;
    }

    @Nullable
    public static PsiClass getPsiClassFromFieldOrGetter(PsiClass classToSearchIn, PsiClass ancestorClass, String fieldName) {
        PsiClass psiClassWithTypeInheritedFromFieldImplementation = JavaUtil.getPsiClassWithTypeInheritedFromFieldImplementation(classToSearchIn, ancestorClass, fieldName);
        if (psiClassWithTypeInheritedFromFieldImplementation == null) {
            return JavaUtil.getPsiClassWithTypeInheritedFromGetter(classToSearchIn, ancestorClass, "get" + JavaUtil.capitalizeFirstLetter(fieldName));
        }
        return psiClassWithTypeInheritedFromFieldImplementation;
    }

    @Nullable
    public static PsiClass getFieldMetaImplClassByFieldMetaBuilderFqnPostfixWithPoint(PsiClass classToSearchIn, @NotNull Module module, String fieldMetaBuilderPostfixWithPoint, String fieldName) {
        PsiClass bcEnumServiceImplClass;
        if (module == null) {
            JavaUtil.$$$reportNull$$$0(55);
        }
        if (classToSearchIn != null && (bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(classToSearchIn)) != null) {
            if (!(classToSearchIn instanceof PsiClassImpl)) {
                throw new PlatformValidationException("bc service = " + classToSearchIn.getQualifiedName() + " cannot be parsed. Is service is a compiled class, that is not in your source code?", (NavigatablePsiElement)classToSearchIn, classToSearchIn.getProject());
            }
            PsiClassImpl bcServClz = (PsiClassImpl)classToSearchIn;
            return JavaUtil.getPsiClassFromConstructorOrFieldOrGetter((PsiClass)bcServClz, fieldMetaBuilderPostfixWithPoint, fieldName);
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClassWithTypeInheritedFromFieldImplementation(PsiClass classForSearchField, PsiClass psiClass, String fieldName) {
        if (classForSearchField != null && psiClass != null) {
            return Arrays.stream(classForSearchField.getFields()).filter(field -> field.getName().equalsIgnoreCase(fieldName)).map(PsiVariable::getInitializer).map(expression -> JavaUtil.getPsiClassFromExpressionsWithTypeInheritedIfPossibly(new PsiExpression[]{expression}, psiClass)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClassWithTypeInheritedFromGetter(PsiClass classForSearchGetter, PsiClass psiClass, String getterName) {
        if (classForSearchGetter != null && psiClass != null) {
            return Arrays.stream(classForSearchGetter.findMethodsByName(getterName, true)).map(PsiMethod::getBody).map(block -> PsiTreeUtil.findChildrenOfType((PsiElement)block, PsiReturnStatement.class)).flatMap(Collection::stream).map(PsiReturnStatement::getReturnValue).map(expression -> JavaUtil.getPsiClassFromExpressionsWithTypeInheritedIfPossibly(new PsiExpression[]{expression}, psiClass)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public static PsiClass getPsiClassFromExpressionsWithTypeInheritedIfPossibly(PsiExpression[] expressions, PsiClass psiClass) {
        PsiManager manager = psiClass.getManager();
        return Arrays.stream(expressions).filter(PsiClassObjectAccessExpression.class::isInstance).map(PsiClassObjectAccessExpression.class::cast).filter(expression -> expression.getOperand().getType() instanceof PsiClassReferenceType).map(expression -> (PsiClassReferenceType)expression.getOperand().getType()).map(PsiUtil::resolveClassInClassTypeOnly).filter(Objects::nonNull).filter(metaBuilderCandidateClass -> metaBuilderCandidateClass.isInheritor(psiClass, true) || manager.areElementsEquivalent((PsiElement)metaBuilderCandidateClass, (PsiElement)psiClass)).findFirst().orElse(null);
    }

    public static boolean isAbstractOrInterfaceClass(PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass.isInterface()) {
            return true;
        }
        return psiClass.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiClass getClassFromProjectAndLibrariesByFqn(@NotNull Project project, @NotNull Module module, @NotNull String classFqn) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(56);
        }
        if (module == null) {
            JavaUtil.$$$reportNull$$$0(57);
        }
        if (classFqn == null) {
            JavaUtil.$$$reportNull$$$0(58);
        }
        GlobalSearchScope scope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project);
        return JavaPsiFacade.getInstance((Project)project).findClass(classFqn, scope);
    }

    @NotNull
    public static boolean hasClassInProjectAndLibrariesByFqn(@NotNull Project project, @NotNull Module module, @NotNull String classFqn) {
        if (project == null) {
            JavaUtil.$$$reportNull$$$0(59);
        }
        if (module == null) {
            JavaUtil.$$$reportNull$$$0(60);
        }
        if (classFqn == null) {
            JavaUtil.$$$reportNull$$$0(61);
        }
        return JavaUtil.getClassFromProjectAndLibrariesByFqn(project, module, classFqn) != null;
    }

    public static PsiClass safetyFindClass(JavaPsiFacade facade, String fqn, GlobalSearchScope scope) {
        if (facade == null || fqn == null || scope == null) {
            return null;
        }
        return facade.findClass(fqn, scope);
    }

    public static NavigatablePsiElement getNavigatableElement(PsiElement psiElement) {
        return (NavigatablePsiElement)ApplicationManager.getApplication().runReadAction(() -> {
            NavigatablePsiElement navigatable;
            if (psiElement instanceof NavigatablePsiElement && (navigatable = (NavigatablePsiElement)psiElement).canNavigate()) {
                return navigatable;
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 15, 21, 24, 26, 27, 28, 30, 33, 34, 39, 45, 49, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorsClassFqn";
                break;
            }
            case 2: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 39: 
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/JavaUtil";
                break;
            }
            case 5: 
            case 9: 
            case 20: 
            case 35: 
            case 41: 
            case 46: 
            case 50: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 36: 
            case 42: 
            case 55: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scp";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassFqnPrefixWithoutPlatformRootPackage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorsClassFqnWithoutPackegPrefix";
                break;
            }
            case 19: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiEnumConstant";
                break;
            }
            case 37: 
            case 43: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnGenericBaseClassFQN";
                break;
            }
            case 38: 
            case 44: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/JavaUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassGenericByIndexFromAncestor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInheritorClasses";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriClassFromGenericByIndexFromAncestorClassFqnWithoutPackegPrefix";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findPsiClass";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeFirstLetter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "deCapitalizeFirstLetter";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findRefs";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostConcreteInheritorInList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "decompileIfNeeded";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepMethodByNameAndReturnTypeIsDeepInheritorOf";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepMethodByNameAndReturnStatementTypeIsDeepInheritorOf";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassGenericByIndexFromAncestor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 39: 
            case 45: 
            case 49: 
            case 53: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllInheritorClasses";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassByFqnPrefixWithoutPlatformRootPackage";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPriClassFromGenericByIndexFromAncestorClassFqnWithoutPackegPrefix";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeFromGenericByIndexFromAncestor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNextNewLineAfterClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeFirstLetter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deCapitalizeFirstLetter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getMostConcreteInheritorInList";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "safeGetEnumFirstStringArgument";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "decompileIfNeeded";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDeepMethodByNameAndReturnTypeIsDeepInheritorOf";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeCandidates";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findDeepMethodByNameAndReturnStatementTypeIsDeepInheritorOf";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findDeepMethodByNameAndReturnStatementTypeFirstGenericArgumentIsDeepInheritorOf";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceImplementaions";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getFieldMetaImplClassByFieldMetaBuilderFqnPostfixWithPoint";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getClassFromProjectAndLibrariesByFqn";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasClassInProjectAndLibrariesByFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 15, 21, 24, 26, 27, 28, 30, 33, 34, 39, 45, 49, 53 -> new IllegalStateException(string);
        };
    }

    public static class PsiJavaElementPatternFacade {
        @NotNull
        public static PsiJavaElementPattern.Capture<PsiLiteral> psiLiteralString() {
            PsiJavaElementPattern.Capture capture = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().and((ElementPattern)new FilterPattern(new ElementFilter(){

                public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                    PsiLiteral psiLiteral;
                    return element instanceof PsiLiteral && PsiJavaElementPatternFacade.isStringOrCharacterLiteral((PsiElement)(psiLiteral = (PsiLiteral)element)) && psiLiteral.getValue() instanceof String;
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            }));
            if (capture == null) {
                PsiJavaElementPatternFacade.$$$reportNull$$$0(0);
            }
            return capture;
        }

        public static boolean isStringOrCharacterLiteral(PsiElement place) {
            return place instanceof PsiLiteralExpression && PsiUtil.isJavaToken((PsiElement)place.getFirstChild(), (TokenSet)ElementType.TEXT_LITERALS);
        }

        public static <T extends PsiLiteral> PsiJavaElementPattern<T, ?> methodCallParameter(@NotNull PsiJavaElementPattern<T, ?> methodCallParameterPattern, final @NotNull ElementPattern<? extends PsiMethod> methodPattern, final @NotNull List<String> methodParamAnnotations) {
            if (methodCallParameterPattern == null) {
                PsiJavaElementPatternFacade.$$$reportNull$$$0(1);
            }
            if (methodPattern == null) {
                PsiJavaElementPatternFacade.$$$reportNull$$$0(2);
            }
            if (methodParamAnnotations == null) {
                PsiJavaElementPatternFacade.$$$reportNull$$$0(3);
            }
            final PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance((Iterable)methodPattern.getCondition().getConditions(), PsiNamePatternCondition.class);
            return (PsiJavaElementPattern)methodCallParameterPattern.with(new PatternCondition<T>("methodCallParameter"){

                public boolean accepts(@NotNull T methodCallParameter, ProcessingContext context) {
                    if (methodCallParameter == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (methodParamAnnotations.isEmpty()) {
                        return false;
                    }
                    PsiElement parent = methodCallParameter.getParent();
                    if (parent instanceof PsiExpressionList) {
                        PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                        if (methodCallParameter instanceof PsiExpression) {
                            PsiExpression methodParameterTyped = (PsiExpression)methodCallParameter;
                            PsiElement element = psiExpressionList.getParent();
                            if (element instanceof PsiMethodCallExpression) {
                                PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)element;
                                PsiReferenceExpression methodExpression = psiMethodCallExpression.getMethodExpression();
                                if (nameCondition != null && !nameCondition.getNamePattern().accepts((Object)methodExpression.getReferenceName())) {
                                    return false;
                                }
                                for (JavaResolveResult result : methodExpression.multiResolve(false)) {
                                    PsiElement psiMethodCandidate = result.getElement();
                                    if (!methodPattern.accepts((Object)psiMethodCandidate, context) || !(psiMethodCandidate instanceof PsiMethod)) continue;
                                    PsiParameter parameterForArgument = MethodCallUtils.getParameterForArgument((PsiExpression)methodParameterTyped);
                                    return parameterForArgument != null && Arrays.stream(parameterForArgument.getAnnotations()).anyMatch(annotation -> methodParamAnnotations.stream().anyMatch(arg_0 -> ((PsiAnnotation)annotation).hasQualifiedName(arg_0)));
                                }
                            }
                            return false;
                        }
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallParameter", "org/cxbox/intellij/community/common/util/JavaUtil$PsiJavaElementPatternFacade$2", "accepts"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/JavaUtil$PsiJavaElementPatternFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallParameterPattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodPattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodParamAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiLiteralString";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/JavaUtil$PsiJavaElementPatternFacade";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "methodCallParameter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

