/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Common {
    public static PsiElementPattern.Capture<JsonStringLiteral> createPropertyNamePatternByParent(final @NotNull List<String> propertyNames, final String fileEndsWith) {
        if (propertyNames == null) {
            Common.$$$reportNull$$$0(0);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonStringLiteral castedElement;
                JsonProperty property;
                JsonProperty parentProperty;
                if (element instanceof JsonStringLiteral && (parentProperty = JsonFacade.getParentOfType((PsiElement)(property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonStringLiteral)element), JsonProperty.class, true)), JsonProperty.class, true)) != null && propertyNames.stream().anyMatch(propertyName -> propertyName.equals(parentProperty.getName())) && Objects.equals(property.getName(), JsonFacade.safeGetValueAsString((PsiElement)castedElement))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonStringLiteral> createPropertyNamePattern(final @NotNull List<String> propertyNames, final String fileEndsWith) {
        if (propertyNames == null) {
            Common.$$$reportNull$$$0(1);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonStringLiteral castedElement;
                JsonProperty property;
                if (element instanceof JsonStringLiteral && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonStringLiteral)element), JsonProperty.class, true)) != null && propertyNames.stream().anyMatch(propertyName -> propertyName.equals(property.getName()) && propertyName.equals(JsonFacade.safeGetValueAsString((PsiElement)castedElement)))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull List<String> propertyNames, final String fileEndsWith) {
        if (propertyNames == null) {
            Common.$$$reportNull$$$0(2);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue castedElement;
                JsonProperty property;
                if (element instanceof JsonValue && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonValue)element), JsonProperty.class, true)) != null && property.getValue() == element && propertyNames.stream().anyMatch(propertyName -> propertyName.equals(property.getName()))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePatternWithPostfix(final @NotNull List<String> propertyNamesPostfix, final String fileEndsWith) {
        if (propertyNamesPostfix == null) {
            Common.$$$reportNull$$$0(3);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue castedElement;
                JsonProperty property;
                if (element instanceof JsonValue && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonValue)element), JsonProperty.class, true)) != null && property.getValue() == element && propertyNamesPostfix.stream().anyMatch(postfix -> !property.getName().equals(postfix) && property.getName().endsWith((String)postfix))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonProperty> createPropertyPatternByParent(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(4);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonProperty.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonProperty castedElement;
                JsonProperty parentProperty;
                if (element instanceof JsonProperty && (parentProperty = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonProperty)element), JsonProperty.class, true)) != null && parentPropertyNames.stream().anyMatch(propertyName -> propertyName.equals(parentProperty.getName()))) {
                    PsiFile file = parentProperty.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonProperty> createPropertyNamePatternByProperty(final @NotNull List<String> propertyNames, final String fileEndsWith) {
        if (propertyNames == null) {
            Common.$$$reportNull$$$0(5);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonProperty.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonProperty) {
                    JsonProperty castedElement = (JsonProperty)element;
                    if (propertyNames.stream().anyMatch(propertyName -> propertyName.equals(castedElement.getName()))) {
                        PsiFile file = castedElement.getContainingFile();
                        return file != null && file.getName().endsWith(fileEndsWith);
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePatternByParent(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(6);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    JsonValue castedElement = (JsonValue)element;
                    JsonProperty property = JsonFacade.getParentOfType((PsiElement)castedElement, JsonProperty.class, true);
                    JsonProperty parentProperty = JsonFacade.getParentOfType((PsiElement)property, JsonProperty.class, true);
                    if (property != null && property.getValue() == element && parentProperty != null && parentPropertyNames.stream().anyMatch(parentPropertyName -> parentPropertyName.equals(parentProperty.getName()))) {
                        PsiFile file = property.getContainingFile();
                        return file != null && file.getName().endsWith(fileEndsWith);
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePatternByNameParentAnyLevel(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(7);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue castedElement;
                JsonProperty property;
                if (element instanceof JsonValue && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonValue)element), JsonProperty.class, true)) != null && property.getValue() == element && parentPropertyNames.stream().anyMatch(parentPropertyName -> Common.hasParentPropertyWithName(property, parentPropertyName))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyNamePatternByNameParentAnyLevel(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(8);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue castedElement;
                JsonProperty property;
                if (element instanceof JsonValue && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonValue)element), JsonProperty.class, true)) != null && parentPropertyNames.stream().anyMatch(parentPropertyName -> Common.hasParentPropertyWithName(property, parentPropertyName))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createArrayPropertyValuePatternByNameParentAnyLevel(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(9);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue castedElement;
                JsonProperty property;
                if (element instanceof JsonValue && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonValue)element), JsonProperty.class, true)) != null && property.getValue() == ((JsonValue)element).getParent() && parentPropertyNames.stream().anyMatch(parentPropertyName -> Common.hasParentPropertyWithName(property, parentPropertyName))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePatternByGrandParent(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(10);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    JsonValue castedElement = (JsonValue)element;
                    JsonProperty property = JsonFacade.getParentOfType((PsiElement)castedElement, JsonProperty.class, true);
                    JsonProperty parentProperty = JsonFacade.getParentOfType((PsiElement)property, JsonProperty.class, true);
                    JsonProperty grandParentProperty = JsonFacade.getParentOfType((PsiElement)parentProperty, JsonProperty.class, true);
                    if (property != null && property.getValue() == element && grandParentProperty != null && parentPropertyNames.stream().anyMatch(parentPropertyName -> parentPropertyName.equals(grandParentProperty.getName()))) {
                        PsiFile file = property.getContainingFile();
                        return file != null && file.getName().endsWith(fileEndsWith);
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonStringLiteral> createArrayPropertyValuePatternByParent(final @NotNull List<String> parentPropertyNames, final String fileEndsWith) {
        if (parentPropertyNames == null) {
            Common.$$$reportNull$$$0(11);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonStringLiteral castedElement;
                JsonProperty parentProperty;
                if (element instanceof JsonStringLiteral && (parentProperty = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonStringLiteral)element), JsonProperty.class, true)) != null && parentProperty.getValue() != null && parentProperty.getValue() instanceof JsonArray && ((JsonArray)parentProperty.getValue()).getValueList().contains(element) && parentPropertyNames.stream().anyMatch(parentPropertyName -> parentPropertyName.equals(parentProperty.getName()))) {
                    PsiFile file = parentProperty.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonStringLiteral> createArrayPropertyValue(final @NotNull List<String> propertyNames, final String fileEndsWith) {
        if (propertyNames == null) {
            Common.$$$reportNull$$$0(12);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue castedElement;
                JsonProperty property;
                if (element instanceof JsonValue && (property = JsonFacade.getParentOfType((PsiElement)(castedElement = (JsonValue)element), JsonProperty.class, true)) != null && property.getValue() == ((JsonValue)element).getParent() && propertyNames.stream().anyMatch(propertyName -> propertyName.equals(property.getName()))) {
                    PsiFile file = property.getContainingFile();
                    return file != null && file.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePatternBySibling(final @NotNull String siblingPropertyName, final String fileEndsWith) {
        if (siblingPropertyName == null) {
            Common.$$$reportNull$$$0(13);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    JsonProperty property;
                    JsonValue castedElement = (JsonValue)element;
                    JsonObject object = JsonFacade.getParentOfType((PsiElement)castedElement, JsonObject.class, true);
                    JsonProperty jsonProperty = property = object != null ? object.findProperty(siblingPropertyName) : null;
                    if (property != null) {
                        PsiFile file = property.getContainingFile();
                        return file != null && file.getName().endsWith(fileEndsWith);
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePatternBySibling(final @NotNull String siblingPropertyName, final @NotNull List<String> anyOfSiblingPropertyValues, final String fileEndsWith) {
        if (siblingPropertyName == null) {
            Common.$$$reportNull$$$0(14);
        }
        if (anyOfSiblingPropertyValues == null) {
            Common.$$$reportNull$$$0(15);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    JsonValue castedElement = (JsonValue)element;
                    JsonObject object = JsonFacade.getParentOfType((PsiElement)castedElement, JsonObject.class, true);
                    JsonProperty property = object != null ? object.findProperty(siblingPropertyName) : null;
                    String propertyValue = JsonFacade.safeGetValueAsString((PsiElement)JsonFacade.safeGetPropertyValueOfType(object, siblingPropertyName, JsonStringLiteral.class));
                    if (property != null && anyOfSiblingPropertyValues.contains(propertyValue)) {
                        PsiFile file = property.getContainingFile();
                        return file != null && file.getName().endsWith(fileEndsWith);
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull String propertyName, final String fileEndsWith) {
        if (propertyName == null) {
            Common.$$$reportNull$$$0(16);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonValue jsonValue;
                JsonProperty property;
                if (element instanceof JsonValue && (property = (JsonProperty)ObjectUtils.tryCast((Object)(jsonValue = (JsonValue)element).getParent(), JsonProperty.class)) != null && property.getValue() == element && propertyName.equals(property.getName())) {
                    PsiFile containingFile = jsonValue.getContainingFile();
                    return containingFile != null && containingFile.getName().endsWith(fileEndsWith);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static boolean hasParentPropertyWithName(@NotNull JsonProperty property, @NotNull String parentName) {
        if (property == null) {
            Common.$$$reportNull$$$0(17);
        }
        if (parentName == null) {
            Common.$$$reportNull$$$0(18);
        }
        JsonProperty parent = property;
        while ((parent = JsonFacade.getParentOfType((PsiElement)parent, JsonProperty.class, true)) != null) {
            if (!parent.getName().equals(parentName)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNamesPostfix";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPropertyNames";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingPropertyName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyOfSiblingPropertyValues";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/Common";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyNamePatternByParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyNamePattern";
                break;
            }
            case 2: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePatternWithPostfix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyPatternByParent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyNamePatternByProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePatternByParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePatternByNameParentAnyLevel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyNamePatternByNameParentAnyLevel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createArrayPropertyValuePatternByNameParentAnyLevel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePatternByGrandParent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createArrayPropertyValuePatternByParent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createArrayPropertyValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePatternBySibling";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "hasParentPropertyWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

