/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.searchParameter.reference;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.PsiCommentUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.java.searchParameter.reference.SearchParameterAnnotationReferenceProvider;
import org.cxbox.intellij.community.java.searchParameter.reference.commentEntityName.FullyNameInCommentInspection;
import org.jetbrains.annotations.NotNull;

public class SearchParameterAnnotationFindEntityInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SearchParameterAnnotationFindEntityInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SearchParameterAnnotationFindEntityInspection.$$$reportNull$$$0(1);
        }
        SmartList descriptors = new SmartList();
        if (file.getText().contains(".core.util.filter.SearchParameter") && file.getText().contains("@SearchParameter")) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module == null) {
                return null;
            }
            PsiClass[] childrenOfTypeFromFile = (PsiClass[])PsiTreeUtil.getChildrenOfType((PsiElement)file, PsiClass.class);
            int INDEX_OF_CLASS_IN_PSI_FILE = 0;
            if (childrenOfTypeFromFile != null && childrenOfTypeFromFile.length > 0 && childrenOfTypeFromFile[INDEX_OF_CLASS_IN_PSI_FILE] != null) {
                PsiClass dto = childrenOfTypeFromFile[INDEX_OF_CLASS_IN_PSI_FILE];
                Optional<PsiLiteralExpression> nameFromAnnotation = Optional.of(dto).stream().map(psiClass -> psiClass).map(PsiClass::getAllFields).flatMap(Arrays::stream).map(field -> {
                    for (String root : Cache.getAllPossiblePlatformRootPackageWithoutDot()) {
                        if (!field.hasAnnotation(root + ".core.util.filter.SearchParameter")) continue;
                        return field.getAnnotation(root + ".core.util.filter.SearchParameter");
                    }
                    return null;
                }).filter(Objects::nonNull).map(psiAnnotation -> psiAnnotation.findAttributeValue("name")).filter(value -> value instanceof PsiLiteralExpression).map(value -> (PsiLiteralExpression)value).findFirst();
                PsiLiteralExpression element = nameFromAnnotation.orElse(null);
                PsiClass entityClass = SearchParameterAnnotationReferenceProvider.getEntityClass(element, module);
                if (entityClass == null && PsiCommentUtil.containCommitWithPrefixes((PsiElement)dto, List.of("@entity:", "//@entity:"))) {
                    String fullyNameFromComment = PsiCommentUtil.getCommentWithPrefixesAndFullyName((PsiElement)element, List.of("@entity:", "//@entity:"));
                    entityClass = FullyNameInCommentInspection.getClassByName(element.getProject(), fullyNameFromComment);
                }
                if (entityClass == null && (entityClass = (PsiClass)ResponseServiceUtils.getEntityByDto(dto, module).orElse(null)) == null) {
                    descriptors.add(manager.createProblemDescriptor((PsiElement)dto, new TextRange(Objects.requireNonNull(dto.getIdentifyingElement()).getStartOffsetInParent(), dto.getIdentifyingElement().getStartOffsetInParent() + dto.getIdentifyingElement().getText().length()), "Entity not found", ProblemHighlightType.WEAK_WARNING, true, new LocalQuickFix[]{new Fix((PsiElement)dto)}));
                }
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationFindEntityInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record Fix(PsiElement className) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Add fully qualified path to entity";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Add fully qualified path to entity";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)this.className.getProject());
            PsiComment newElement = factory.createCommentFromText("//@entity:fully qualified path to entity", this.className);
            this.className.addBefore((PsiElement)newElement, this.className.getChildren()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationFindEntityInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

