/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.ui.component;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;

public class PanelWithTextAndInputAndSuggestion
extends JPanel {
    private static final int LABEL_WIDTH = 100;
    private static final int INPUT_WIDTH = 200;
    private final JLabel labelName;
    private final JComponent input;
    private final JLabel labelHelper;

    public PanelWithTextAndInputAndSuggestion(JLabel labelName, JComponent component, JLabel labelHelper) {
        super(new GridBagLayout());
        this.labelName = labelName;
        this.labelHelper = labelHelper;
        this.input = component;
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.labelName.setPreferredSize(new Dimension(100, this.labelName.getPreferredSize().height));
        this.labelName.setHorizontalAlignment(2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = JBUI.insetsRight((int)8);
        this.add((Component)this.labelName, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this.input, gbc);
        this.input.setSize(new Dimension(200, this.input.getPreferredSize().height));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = JBUI.insets((int)2, (int)2, (int)0, (int)0);
        gbc.fill = 0;
        this.add((Component)this.labelHelper, gbc);
        this.labelHelper.setForeground((Color)JBColor.GRAY);
        this.labelHelper.setFont(this.input.getFont().deriveFont(2, this.input.getFont().getSize() - 2));
    }

    public JLabel getLabelName() {
        return this.labelName;
    }

    public JComponent getInputComponent() {
        return this.input;
    }

    public JLabel getLabelHelper() {
        return this.labelHelper;
    }

    public <T extends JComponent> T getTypedInputElement(Class<T> clazz) {
        return (T)((JComponent)clazz.cast(this.getInputComponent()));
    }

    public <T extends JComponent> T getTypedInputElement() {
        return (T)this.getInputComponent();
    }

    public static <T> ComboBox<T> createComboBox(Collection<T> data, String value, final Class<T> clazz, final Function<T, String> nameFunction) {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel(new ArrayList<T>(data)));
        comboBox.setSwingPopup(false);
        comboBox.setPreferredSize(new Dimension(200, comboBox.getPreferredSize().height));
        comboBox.setEditable(true);
        comboBox.setSelectedItem((Object)value);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<T>(){

            protected void customizeCellRenderer(@NotNull JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
                PsiClass psiValue;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof PsiClass && (psiValue = (PsiClass)value).getName() != null) {
                    this.append(psiValue.getName());
                }
                SpeedSearchUtil.applySpeedSearchHighlighting(list, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/cxbox/intellij/community/wigdet/bc/ui/component/PanelWithTextAndInputAndSuggestion$1", "customizeCellRenderer"));
            }
        });
        comboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){
            private T currentItem;
            private Class<T> tClass;
            private Function<T, String> functionGetName;
            {
                this.tClass = clazz;
                this.functionGetName = nameFunction;
            }

            @Override
            public Object getItem() {
                String editorText = this.editor.getText();
                if (this.tClass.isInstance(this.currentItem) && editorText.equals(this.functionGetName.apply(this.currentItem))) {
                    return this.currentItem;
                }
                return editorText;
            }

            @Override
            public void setItem(Object item) {
                String text;
                this.currentItem = this.tClass.isInstance(item) ? item : null;
                if (item instanceof PsiClass) {
                    PsiClass psi = (PsiClass)item;
                    super.setItem(psi);
                    text = psi.getName();
                } else {
                    super.setItem(item);
                    text = String.valueOf(item);
                }
                this.editor.setText(text);
            }
        });
        return comboBox;
    }
}

