/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.cxbox.intellij.community.action.RunTemplateAction;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.TemplateContextUtil;
import org.cxbox.intellij.community.icons.PlatformIcons;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddWidgetFieldLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final PsiElementPattern.Capture<JsonStringLiteral> WIDGET_FIELDS_PATTERN = Common.createPropertyNamePattern(List.of(JWidget.FIELDS_FIELDS.getName()), ".widget.json");
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace(a)) {
            return 1;
        }
        if (a.shouldReplace(b)) {
            return -1;
        }
        return 0;
    };
    private static final Key<Boolean> HAS_ANYTHING_RUNNABLE = Key.create((String)"HAS_ANYTHING_RUNNABLE");

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement element, @NotNull Icon icon, @NotNull List<RunLineMarkerContributor.Info> infos) {
        if (element == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (infos.size() > 1) {
            infos.sort(COMPARATOR);
            RunLineMarkerContributor.Info first = infos.get(0);
            infos.removeIf(info -> info != first && first.shouldReplace(info));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action : info2.actions) {
                actionGroup.add((AnAction)(action instanceof Separator ? action : new LineMarkerActionWrapper(element, action)));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add((AnAction)new Separator());
        }
        Function tooltipProvider = element1 -> {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : infos) {
                String string;
                if (info.tooltipProvider == null || (string = (String)info.tooltipProvider.apply(element1)) == null) continue;
                if (tooltip.length() != 0) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.length() == 0 ? null : AddWidgetFieldLineMarkerProvider.appendShortcut(tooltip.toString());
        };
        return new RunLineMarkerInfo(element, icon, (Function<? super PsiElement, String>)tooltipProvider, actionGroup);
    }

    private static String appendShortcut(String tooltip) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return tooltip;
        }
        String shortcutText = "inside fields array press Ctl+J or start typing";
        @NotNull String shortcutColor = ColorUtil.toHex((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground());
        return XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.escapeString((String)tooltip).replaceAll("\n", "<br>") + "&nbsp;&nbsp;<font color='#" + shortcutColor + "'>" + XmlStringUtil.escapeString((String)shortcutText) + "</font>"));
    }

    @NotNull
    public static ThreeState hadAnythingRunnable(@NotNull VirtualFile file) {
        Boolean data;
        if (file == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(3);
        }
        ThreeState threeState = (data = (Boolean)file.getUserData(HAS_ANYTHING_RUNNABLE)) == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)data);
        if (threeState == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    public static void markRunnable(@NotNull VirtualFile file, boolean isRunnable) {
        if (file == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(5);
        }
        file.putUserData(HAS_ANYTHING_RUNNABLE, (Object)isRunnable);
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement leaf) {
        PsiElement psiElement;
        if (leaf == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (!(leaf instanceof LeafPsiElement) || !((psiElement = leaf.getParent()) instanceof JsonStringLiteral)) {
            return null;
        }
        JsonStringLiteral element = (JsonStringLiteral)psiElement;
        if (!WIDGET_FIELDS_PATTERN.accepts((Object)element)) {
            return null;
        }
        Icon icon = PlatformIcons.plus;
        List<TemplateContextType> allContextTypes = TemplateContextUtil.getAllTemplateContextTypes();
        TemplateContextType context = allContextTypes.stream().filter(cxt -> cxt.getContextId().equals("PlatformWidgetFieldsContext")).findFirst().orElse(null);
        List<TemplateImpl> frameworkTemplates = TemplateSettings.getInstance().getTemplatesAsList().stream().filter(t -> context != null && t.getTemplateContext().isEnabled(context)).toList();
        AnAction[] actions = (AnAction[])frameworkTemplates.stream().map(template -> new RunTemplateAction((Template)template, JsonFacade.getParentOfType((PsiElement)element, JsonProperty.class, true), JavaFacade.getByTemplateKey(template.getKey()).map(StandardFieldType::getIcon).orElse(null))).toArray(AnAction[]::new);
        ArrayList<RunLineMarkerContributor.Info> infos = new ArrayList<RunLineMarkerContributor.Info>();
        infos.add(new RunLineMarkerContributor.Info(PlatformIcons.plus, actions, e -> "add widget field"));
        return AddWidgetFieldLineMarkerProvider.createLineMarker(leaf, icon, infos);
    }

    @NotNull
    public String getName() {
        String string = ExecutionBundle.message((String)"run.line.marker.name", (Object[])new Object[0]);
        if (string == null) {
            AddWidgetFieldLineMarkerProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/AddWidgetFieldLineMarkerProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/AddWidgetFieldLineMarkerProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "hadAnythingRunnable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hadAnythingRunnable";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markRunnable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }

    static class RunLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final DefaultActionGroup myActionGroup;
        private final AnAction mySingleAction;

        RunLineMarkerInfo(PsiElement element, Icon icon, Function<? super PsiElement, String> tooltipProvider, DefaultActionGroup actionGroup) {
            super(element, element.getTextRange(), icon, tooltipProvider, null, GutterIconRenderer.Alignment.LEFT, () -> (String)tooltipProvider.fun((Object)element));
            this.myActionGroup = actionGroup;
            this.mySingleAction = this.myActionGroup.getChildrenCount() == 1 ? this.myActionGroup.getChildActionsOrStubs()[0] : null;
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return mySingleAction;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }

        @NotNull
        public MarkupEditorFilter getEditorFilter() {
            MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsNotDiffFilter();
            if (markupEditorFilter == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(0);
            }
            return markupEditorFilter;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(1);
            }
            return info instanceof RunLineMarkerInfo && info.getIcon() == this.getIcon();
        }

        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return this.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/AddWidgetFieldLineMarkerProvider$RunLineMarkerInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorFilter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/AddWidgetFieldLineMarkerProvider$RunLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

