/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModuleLibUtils {
    public static boolean moduleContainsLibraryMatching(Module module, List<String> namesToExclude) {
        return (Boolean)ReadAction.compute(() -> {
            AtomicBoolean found = new AtomicBoolean(false);
            ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().forEachLibrary(library -> {
                String libName = library.getName();
                if (libName != null) {
                    if (namesToExclude.stream().noneMatch(libName::contains)) {
                        found.set(true);
                        return false;
                    }
                }
                return true;
            });
            return found.get();
        });
    }

    public static boolean isFromProjectSources(PsiClass psiClass) {
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)psiClass.getProject());
        return fileIndex.isInSourceContent(virtualFile) && !fileIndex.isInLibraryClasses(virtualFile);
    }
}

