/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.utils;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import org.cxbox.intellij.community.common.Cache;

public class RepositoryUtils {
    public static final String BASE_SPRING_FRAMEWORK_REPOSITORY_FQN = "org.springframework.data.repository.Repository";

    private RepositoryUtils() {
    }

    public static Collection<PsiClass> getAllRepository(Module module) {
        return (Collection)ReadAction.compute(() -> {
            PsiClass repoInterface = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(BASE_SPRING_FRAMEWORK_REPOSITORY_FQN, GlobalSearchScope.allScope((Project)module.getProject()));
            ArrayList repositories = new ArrayList();
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)module.getProject());
            if (repoInterface == null) {
                return Collections.emptyList();
            }
            boolean isSuccess = ClassInheritorsSearch.search((PsiClass)repoInterface, (SearchScope)scope, (boolean)true).filtering(psc -> psc.getQualifiedName() != null && !psc.getQualifiedName().startsWith("org.springframework")).filtering(psc -> Arrays.stream(psc.getSuperTypes()).map(s -> RepositoryUtils.getEntityClassFromRepositoryType((PsiType)s, module)).filter(Objects::nonNull).anyMatch(pse -> pse.isInheritor(Cache.getBaseEntityClass(module.getProject(), module), true))).allowParallelProcessing().forEach(repositories::add);
            return isSuccess ? repositories : Collections.emptyList();
        });
    }

    public static Boolean isContainRepository(Module module) {
        return (Boolean)ReadAction.compute(() -> {
            PsiClass repoInterface = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(BASE_SPRING_FRAMEWORK_REPOSITORY_FQN, GlobalSearchScope.allScope((Project)module.getProject()));
            ArrayList repositories = new ArrayList();
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)module.getProject());
            if (repoInterface == null) {
                return false;
            }
            ClassInheritorsSearch.search((PsiClass)repoInterface, (SearchScope)scope, (boolean)true).filtering(psc -> psc.getQualifiedName() != null && !psc.getQualifiedName().startsWith("org.springframework")).allowParallelProcessing().forEach(repositories::add);
            return !repositories.isEmpty();
        });
    }

    public static PsiClass getEntityClassFromRepositoryType(PsiType repositoryType, Module module) {
        PsiType psiType;
        if (!(repositoryType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)repositoryType;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(BASE_SPRING_FRAMEWORK_REPOSITORY_FQN, GlobalSearchScope.allScope((Project)module.getProject()));
        PsiClass repoInterface = classType.resolve();
        if (repoInterface == null || psiClass == null || psiClass.getQualifiedName() == null) {
            return null;
        }
        if (!psiClass.getQualifiedName().equals(repoInterface.getQualifiedName()) && !repoInterface.isInheritor(psiClass, true)) {
            return null;
        }
        PsiType[] params = classType.getParameters();
        if (params.length < 1 || !((psiType = params[0]) instanceof PsiClassType)) {
            return null;
        }
        PsiClassType entityType = (PsiClassType)psiType;
        return entityType.resolve();
    }

    public static PsiClass findRepoByEntity(PsiClass entityClass, Module module) {
        if (entityClass == null) {
            return null;
        }
        return RepositoryUtils.getAllRepository(module).stream().filter(RepositoryUtils.getPsiClassPredicate(entityClass, module)).findFirst().orElse(null);
    }

    public static Predicate<PsiClass> getPsiClassPredicate(PsiClass entityClass, Module module) {
        return psi -> Arrays.stream(psi.getSuperTypes()).anyMatch(pct -> {
            PsiClass entityClassFromRepositoryType = RepositoryUtils.getEntityClassFromRepositoryType((PsiType)pct, module);
            return entityClass != null && entityClass.equals(entityClassFromRepositoryType);
        });
    }
}

