/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.exception;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.MouseInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/cxbox/intellij/community/exception/InternalErrorPlatformException;", "Lorg/cxbox/intellij/community/exception/PlatformValidationException;", "text", "", "psiElement", "Lcom/intellij/psi/NavigatablePsiElement;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/NavigatablePsiElement;Ljava/lang/Exception;Lcom/intellij/openapi/project/Project;)V", "showPopupWithLinks", "", "showPopup", "popup", "Lcom/intellij/openapi/ui/popup/Balloon;", "cxbox-intellij-plugin"})
public final class InternalErrorPlatformException
extends PlatformValidationException {
    public InternalErrorPlatformException(@NotNull String text, @Nullable NavigatablePsiElement psiElement, @NotNull Exception e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(text, psiElement, e, project);
        this.setText(text);
        this.setPsiElement(psiElement);
        this.setOrigException(e);
        this.setProject(project);
    }

    @Override
    public void showPopupWithLinks() {
        if (!StringsKt.contains$default((CharSequence)this.getText(), (CharSequence)"href", (boolean)false, (int)2, null) && this.getPsiElement() != null) {
            this.setText(this.getText() + ". <a href=\"1\">See</a>");
        }
        Ref.ObjectRef stackTracePopup = new Ref.ObjectRef();
        if (this.getOrigException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable throwable = this.getOrigException();
            Intrinsics.checkNotNull((Object)throwable);
            throwable.printStackTrace(pw);
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String stackTraceString = string;
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            if (!(((Object[])stackTraceElementArray).length == 0)) {
                this.setText(StringsKt.trimIndent((String)(" \n                          " + this.getText() + "  <p>(<a href=\"stackTraceLink\">Open Stack Trace</a>)</p>")));
            }
            stackTracePopup.element = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(stackTraceString, MessageType.ERROR, InternalErrorPlatformException::showPopupWithLinks$lambda$0).setHideOnLinkClick(true).createBalloon();
        }
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.getText(), MessageType.ERROR, arg_0 -> InternalErrorPlatformException.showPopupWithLinks$lambda$1(this, stackTracePopup, arg_0)).setHideOnLinkClick(true).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon popup = balloon;
        this.showPopup(popup);
    }

    private final void showPopup(Balloon popup) {
        if (MouseInfo.getPointerInfo().getLocation() != null) {
            popup.show(new RelativePoint(MouseInfo.getPointerInfo().getLocation()), Balloon.Position.atRight);
        }
        JFrame jFrame = WindowManager.getInstance().getFrame(this.getProject());
        popup.showInCenterOf((JComponent)(jFrame != null ? jFrame.getRootPane() : null));
    }

    private static final void showPopupWithLinks$lambda$0(HyperlinkEvent hyperlinkEvent) {
    }

    private static final void showPopupWithLinks$lambda$1(InternalErrorPlatformException this$0, Ref.ObjectRef $stackTracePopup, HyperlinkEvent e) {
        block0: {
            block1: {
                if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block0;
                if (!Intrinsics.areEqual((Object)e.getDescription(), (Object)"stackTraceLink")) break block1;
                Object object = $stackTracePopup.element;
                Intrinsics.checkNotNull((Object)object);
                this$0.showPopup((Balloon)object);
                break block0;
            }
            NavigatablePsiElement navigatablePsiElement = this$0.getPsiElement();
            if (navigatablePsiElement == null) break block0;
            navigatablePsiElement.navigate(true);
        }
    }
}

