/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.ui.component;

import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cxbox.intellij.community.wigdet.bc.BCInspection;

public class SuggestionPanel
extends JPanel {
    private JLabel textLabel;
    private JButton linkButton;
    private boolean showButton;
    private PsiPackage psiPackage;
    private boolean state = false;
    private String text;
    private Consumer<String> updateRelatedComponent;

    public SuggestionPanel(Project project, String name, BCInspection.FixWithCreationBc.BcCreationMetaData metaData) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        this.textLabel = new JBLabel();
        this.textLabel.setForeground((Color)JBColor.GRAY);
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(2, this.textLabel.getFont().getSize() - 2));
        this.textLabel.setText("Type or select");
        this.linkButton = this.createLinkButton("Change " + name + " package", e -> {
            PackageChooserDialog chooser = new PackageChooserDialog("Choose " + name + " package", project);
            chooser.selectPackage(this.text);
            chooser.showAndGet();
            this.psiPackage = chooser.getSelectedPackage();
            if (this.psiPackage != null && this.updateRelatedComponent != null) {
                this.updateRelatedComponent.accept(this.psiPackage.getQualifiedName());
            }
        });
        this.add(this.textLabel);
        this.showButton = false;
    }

    public PsiPackage getPsiPackage() {
        return this.psiPackage;
    }

    public void updateText(String text) {
        this.text = text;
    }

    public void setUpdateRelatedComponent(Consumer<String> updateRelatedComponent) {
        this.updateRelatedComponent = updateRelatedComponent;
    }

    public void enableButton(boolean enable) {
        this.linkButton.setEnabled(enable);
    }

    public void setState(boolean state) {
        this.state = state;
        this.updateComponent(state);
    }

    private void updateComponent(boolean showButton) {
        this.showButton = showButton;
        if (showButton) {
            if (this.linkButton.getParent() == null) {
                this.add(this.linkButton);
            }
        } else if (this.linkButton.getParent() != null) {
            this.remove(this.linkButton);
        }
        this.revalidate();
        this.repaint();
    }

    private JButton createLinkButton(String text, ActionListener action) {
        final JButton button = new JButton(text);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setBorder(null);
        button.setFont(button.getFont().deriveFont(2, button.getFont().getSize() - 2));
        button.setForeground((Color)JBColor.BLUE);
        button.setCursor(new Cursor(12));
        final String originalText = text;
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setText("<html><u>" + originalText + "</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setText(originalText);
            }
        });
        if (action != null) {
            button.addActionListener(action);
        }
        return button;
    }
}

