/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.searchParameter.reference;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.reference.PsiMemberReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchParameterAnnotationReferenceProvider
extends PsiReferenceProvider {
    @Nullable
    public static PsiClass getEntityClass(PsiLiteralExpression dtoPsiField, Module module) {
        PsiClass dtoPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)dtoPsiField, PsiClass.class, (boolean)false);
        if (dtoPsiClass == null) {
            return null;
        }
        return ResponseServiceUtils.getEntityByDto(dtoPsiClass, module).orElse(null);
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
        if (psiElement == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(0);
        }
        if (processingContext == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof PsiLiteralExpression)) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        List<Object> refs = new ArrayList();
        Object object = psiLiteralExpression.getValue();
        if (object instanceof String) {
            String value = (String)object;
            refs = this.refs(psiLiteralExpression, value, module);
        }
        return refs.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
    }

    @NotNull
    private List<PsiReference> refs(@NotNull PsiLiteralExpression dtoPsiField, @NotNull String value, @NotNull Module module) {
        PsiClass entityClass;
        if (dtoPsiField == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(2);
        }
        if (value == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(4);
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        String[] fields = value.split("\\.", -1);
        PsiClass dtoPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)dtoPsiField, PsiClass.class, (boolean)false);
        if (dtoPsiClass == null) {
            ArrayList<PsiReference> arrayList = refs;
            if (arrayList == null) {
                SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        Object pos_i_entityField_class = entityClass = (PsiClass)ResponseServiceUtils.getEntityByDto(dtoPsiClass, module).orElse(null);
        for (int i = 0; i < fields.length; ++i) {
            PsiClass clz;
            PsiClass pos_i_entity_class = pos_i_entityField_class;
            List<LookupElement> lookupElements = this.getLookupElements(module, pos_i_entity_class);
            String pos_i_currentValue = fields[i];
            PsiField pos_i_entityField = Optional.ofNullable(pos_i_entityField_class).map(e -> e.findFieldByName(pos_i_currentValue, true)).orElse(null);
            pos_i_entityField_class = JavaFacade.isFieldCollectionWithGenericEntityOrEmbeddable(pos_i_entityField, module) != false ? (PsiClass)JavaFacade.getClassFromGenericLast(pos_i_entityField).orElse(null) : (JavaFacade.isEntity(clz = JavaFacade.getClassByField(pos_i_entityField), module) != false ? clz : null);
            refs.add((PsiReference)new ReferenceLinkFromSearchParameter(dtoPsiField, this.getTextRangeDotAware(i, fields), (PsiElement)pos_i_entityField, lookupElements, (PsiClass)pos_i_entityField_class, pos_i_entityField == null ? false : pos_i_entityField.getAnnotation(Cache.getPersistenceVersionWithoutDot(module.getProject(), module) + ".ElementCollection") != null));
        }
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private TextRange getTextRangeDotAware(int i, @NotNull String[] fields) {
        if (fields == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(7);
        }
        int end = 0;
        for (int j = 0; j <= i; ++j) {
            end += (j == 0 ? 0 : 1) + fields[j].length();
        }
        return new TextRange(end - fields[i].length() + 1, end + 1);
    }

    @NotNull
    private List<LookupElement> getLookupElements(@NotNull Module module, @Nullable PsiClass entityClass) {
        if (module == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(8);
        }
        if (entityClass == null || !JavaFacade.isEntity(entityClass, module).booleanValue()) {
            return new ArrayList<LookupElement>();
        }
        return this.getListCheckedToTransient(entityClass, module);
    }

    @NotNull
    private List<LookupElement> getListCheckedToTransient(@Nullable PsiClass psiClass, @NotNull Module module) {
        PsiField[] psiFields;
        if (module == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<LookupElement> resultFieldsName = new ArrayList<LookupElement>();
        for (PsiField field : psiFields = psiClass.getAllFields()) {
            if (field.hasAnnotation(Cache.getPersistenceVersionWithoutDot(module.getProject(), module) + ".Transient") || field.hasModifierProperty("static")) continue;
            resultFieldsName.add((LookupElement)JavaLookupElementBuilder.forField((PsiField)field));
        }
        ArrayList<LookupElement> arrayList = resultFieldsName;
        if (arrayList == null) {
            SearchParameterAnnotationReferenceProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtoPsiField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationReferenceProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationReferenceProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "refs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCheckedToTransient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refs";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeDotAware";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getListCheckedToTransient";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static class ReferenceLinkFromSearchParameter
    extends PsiReferenceBase<PsiLiteralExpression>
    implements PsiMemberReference {
        final PsiElement resolve;
        final List variants;
        final PsiClass pos_i_entityField_class;
        final boolean isFieldHasCollectionAnnotation;

        public ReferenceLinkFromSearchParameter(@NotNull PsiLiteralExpression element, @NotNull TextRange rangeInElement, @Nullable PsiElement resolve, @NotNull List variants, PsiClass pos_i_entityField_class, boolean isFieldHasCollectionAnnotation) {
            if (element == null) {
                ReferenceLinkFromSearchParameter.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                ReferenceLinkFromSearchParameter.$$$reportNull$$$0(1);
            }
            if (variants == null) {
                ReferenceLinkFromSearchParameter.$$$reportNull$$$0(2);
            }
            super((PsiElement)element, rangeInElement, false);
            this.resolve = resolve;
            this.variants = variants;
            this.pos_i_entityField_class = pos_i_entityField_class;
            this.isFieldHasCollectionAnnotation = isFieldHasCollectionAnnotation;
        }

        public boolean isCorrectPathPart() {
            if (this.isFieldHasCollectionAnnotation) {
                return true;
            }
            return this.resolve != null;
        }

        public boolean isCorrectEnding() {
            if (this.isFieldHasCollectionAnnotation) {
                return true;
            }
            return this.resolve != null && this.pos_i_entityField_class == null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                ReferenceLinkFromSearchParameter.$$$reportNull$$$0(3);
            }
            return element;
        }

        @Nullable
        public PsiElement resolve() {
            return this.resolve;
        }

        public Object[] getVariants() {
            return this.variants.toArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
            }
            objectArray2[1] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationReferenceProvider$ReferenceLinkFromSearchParameter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bindToElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

