/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service;

import com.intellij.openapi.module.Module;
import com.intellij.psi.NavigatablePsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.BCInspection;
import org.cxbox.intellij.community.wigdet.bc.service.generator.AbstractBcServiceGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcDialogCreationData;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.service.generator.anysource.AnySourceElementsGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareElementsGenerator;

public class BcServiceGeneratorHolder {
    private static final List<AbstractBcServiceGenerator<BcDialogCreationData, ElementGenerationContext.ElementBcData, ElementGenerationContext>> elementsGenerators = new ArrayList<AbstractBcServiceGenerator<BcDialogCreationData, ElementGenerationContext.ElementBcData, ElementGenerationContext>>();

    private static ElementGenerationContext.ElementBcData createElements(Module module, BcDialogCreationData bcDialogCreationData, NavigatablePsiElement navigatablePsiElement) throws Exception {
        if (bcDialogCreationData.serviceType() != null) {
            Set elementsGeneratorSet = elementsGenerators.stream().filter(eg -> eg.isApplicable(module, bcDialogCreationData)).collect(Collectors.toSet());
            if (elementsGeneratorSet.size() > 1) {
                throw new PlatformValidationException("Internal error! Please copy stacktrace and contact with administrator", null, new IllegalStateException("Found more than one type elements generator"), module.getProject());
            }
            if (elementsGeneratorSet.isEmpty()) {
                throw new PlatformValidationException("Internal error! Please copy stacktrace and contact with administrator", null, new IllegalStateException("Not found elements generator"), module.getProject());
            }
            return (ElementGenerationContext.ElementBcData)((AbstractBcServiceGenerator)elementsGeneratorSet.iterator().next()).createElements(module, bcDialogCreationData, navigatablePsiElement);
        }
        throw new PlatformValidationException("Internal error! Please copy stacktrace and contact with administrator", null, new IllegalStateException("Not chosen service type "), module.getProject());
    }

    public static ElementGenerationContext.ElementBcData create(Module module, BcDialogCreationData bcDialogCreationData, BCInspection.FixWithCreationBc.BcCreationMetaData bcCreationMetaData) throws Exception {
        return BcServiceGeneratorHolder.createElements(module, bcDialogCreationData, bcCreationMetaData.element());
    }

    static {
        elementsGenerators.add(new VersionAwareElementsGenerator());
        elementsGenerators.add(new AnySourceElementsGenerator());
    }

    public static enum ElementType {
        ENTITY,
        DTO,
        META,
        SERVICE,
        ENUM_BC,
        REPO,
        DAO;

    }
}

