/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.jetbrains.annotations.Nullable;

public enum AwareResponseServiceType {
    VERSION_AWARE_RESPONSE_SERVICE("VersionAwareResponseService"),
    ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE("AnySourceVersionAwareResponseService"),
    UNKNOWN("Unknown");

    private final String className;

    private AwareResponseServiceType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    @Nullable
    public static AwareResponseServiceType getServiceTypeFromPsiServiceClass(PsiClass psiClass, Project project, Module module) {
        if (ResponseServiceUtils.isVersionAwareResponseService(psiClass, project, module)) {
            return VERSION_AWARE_RESPONSE_SERVICE;
        }
        if (ResponseServiceUtils.isAnySourceVersionAwareResponseService(psiClass, project, module)) {
            return ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE;
        }
        return UNKNOWN;
    }

    public static AwareResponseServiceType getServiceTypeFromPsiConstant(PsiEnumConstant constant, Project project, Module module) {
        PsiClass bcServiceClass = EnumBcUtil.getBcServiceClass(constant, project, module);
        return AwareResponseServiceType.getServiceTypeFromPsiServiceClass(bcServiceClass, project, module);
    }
}

