/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.screen.navigation;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonPropertyImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.screen.navigation.ChildViewNameDuplicateInspection;
import org.jetbrains.annotations.NotNull;

public class ChildInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ChildInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ChildInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".screen.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        List<JsonArray> menu = ChildViewNameDuplicateInspection.getMenu(jsonFile);
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(menu.stream().map(JsonArray::getValueList).flatMap(Collection::stream).filter(JsonObject.class::isInstance).map(menu1 -> JsonFacade.safeGetPropertyValueOfType((JsonObject)menu1, JScreen.CHILD)).filter(Objects::nonNull).map(array -> {
            List<JsonArray> allChild = ChildViewNameDuplicateInspection.getAllChild(array);
            allChild.add((JsonArray)array);
            return allChild;
        }).flatMap(Collection::stream).toList());
        children.addAll(menu);
        children.stream().filter(child -> child.getValueList().isEmpty() || !this.hasObjectWithViewNameOrChild((JsonArray)child)).forEach(arg_0 -> ChildInspection.lambda$checkFile$3((List)descriptors, manager, file, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private boolean hasObjectWithViewNameOrChild(@NotNull JsonArray array) {
        if (array == null) {
            ChildInspection.$$$reportNull$$$0(2);
        }
        return array.getValueList().stream().filter(obj -> obj.getChildren().length > 0).anyMatch(obj -> {
            for (PsiElement element : obj.getChildren()) {
                String name = ((JsonProperty)element).getName();
                if (!JScreen.VIEW_NAME.getName().equals(name) && !JScreen.CHILD.getName().equals(name)) continue;
                return true;
            }
            return false;
        });
    }

    private static /* synthetic */ void lambda$checkFile$3(List descriptors, InspectionManager manager, PsiFile file, JsonArray child) {
        int textOffset = ((JsonPropertyImpl)child.getParent()).getNameElement().getTextOffset();
        descriptors.add(manager.createProblemDescriptor((PsiElement)file, new TextRange(textOffset + 1, textOffset + ((JsonPropertyImpl)child.getParent()).getNameElement().getTextLength() - 1), "Child must have at least one \"viewName\"", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/screen/navigation/ChildInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasObjectWithViewNameOrChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

